/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.item;

import com.github.tartaricacid.netmusic.api.pojo.NetEaseMusicList;
import com.github.tartaricacid.netmusic.api.pojo.NetEaseMusicSong;
import com.github.tartaricacid.netmusic.init.InitDataComponent;
import com.github.tartaricacid.netmusic.init.InitItems;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.StringUtils;

public class ItemMusicCD
extends Item {
    public static final String SONG_INFO_TAG = "NetMusicSongInfo";

    public ItemMusicCD() {
        super(new Item.Properties());
    }

    @Nullable
    public static SongInfo getSongInfo(ItemStack stack) {
        if (stack.getItem() == InitItems.MUSIC_CD.get()) {
            return (SongInfo)stack.get(InitDataComponent.SONG_INFO);
        }
        return null;
    }

    public static ItemStack setSongInfo(SongInfo info, ItemStack stack) {
        if (stack.getItem() == InitItems.MUSIC_CD.get()) {
            stack.set(InitDataComponent.SONG_INFO, (Object)info);
        }
        return stack;
    }

    public Component getName(ItemStack stack) {
        SongInfo info = ItemMusicCD.getSongInfo(stack);
        if (info != null) {
            Object name = info.songName;
            if (info.vip) {
                name = (String)name + " \u00a74\u00a7l[VIP]";
            }
            if (info.readOnly) {
                MutableComponent readOnlyText = Component.translatable((String)"tooltips.netmusic.cd.read_only").withStyle(ChatFormatting.YELLOW);
                return Component.literal((String)name).append(CommonComponents.SPACE).append((Component)readOnlyText);
            }
            return Component.literal((String)name);
        }
        return super.getName(stack);
    }

    private String getSongTime(int songTime) {
        int min = songTime / 60;
        int sec = songTime % 60;
        String minStr = min <= 9 ? "0" + min : "" + min;
        String secStr = sec <= 9 ? "0" + sec : "" + sec;
        return I18n.get((String)"tooltips.netmusic.cd.time.format", (Object[])new Object[]{minStr, secStr});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        SongInfo info = ItemMusicCD.getSongInfo(stack);
        String prefix = "\u00a7a\u258d \u00a77";
        String delimiter = ": ";
        if (info != null) {
            String text;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{info.transName})) {
                text = "\u00a7a\u258d \u00a77" + I18n.get((String)"tooltips.netmusic.cd.trans_name", (Object[])new Object[0]) + ": \u00a76" + info.transName;
                tooltip.add((Component)Component.literal((String)text));
            }
            if (info.artists != null && !info.artists.isEmpty()) {
                String artistNames = StringUtils.join(info.artists, (String)" | ");
                String text2 = "\u00a7a\u258d \u00a77" + I18n.get((String)"tooltips.netmusic.cd.artists", (Object[])new Object[0]) + ": \u00a73" + artistNames;
                tooltip.add((Component)Component.literal((String)text2));
            }
            text = "\u00a7a\u258d \u00a77" + I18n.get((String)"tooltips.netmusic.cd.time", (Object[])new Object[0]) + ": \u00a75" + this.getSongTime(info.songTime);
            tooltip.add((Component)Component.literal((String)text));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltips.netmusic.cd.empty").withStyle(ChatFormatting.RED));
        }
    }

    public static class SongInfo {
        public static final Codec<SongInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("url").forGetter(i -> i.songUrl), (App)Codec.STRING.fieldOf("name").forGetter(i -> i.songName), (App)Codec.INT.fieldOf("time_second").forGetter(i -> i.songTime), (App)Codec.STRING.optionalFieldOf("trans_name", (Object)"").forGetter(i -> i.transName), (App)Codec.BOOL.optionalFieldOf("vip", (Object)false).forGetter(i -> i.vip), (App)Codec.BOOL.optionalFieldOf("readOnly", (Object)false).forGetter(i -> i.readOnly), (App)Codec.STRING.listOf().optionalFieldOf("artists", Collections.emptyList()).forGetter(i -> i.artists)).apply((Applicative)instance, SongInfo::new));
        private static final StreamCodec<ByteBuf, List<String>> ARTISTS_CODEC = ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8);
        public static final StreamCodec<ByteBuf, SongInfo> STREAM_CODEC = StreamCodec.of((buffer, songInfo) -> {
            ByteBufCodecs.STRING_UTF8.encode(buffer, (Object)songInfo.songUrl);
            ByteBufCodecs.STRING_UTF8.encode(buffer, (Object)songInfo.songName);
            ByteBufCodecs.VAR_INT.encode(buffer, (Object)songInfo.songTime);
            ByteBufCodecs.STRING_UTF8.encode(buffer, (Object)songInfo.transName);
            ByteBufCodecs.BOOL.encode(buffer, (Object)songInfo.vip);
            ByteBufCodecs.BOOL.encode(buffer, (Object)songInfo.readOnly);
            ARTISTS_CODEC.encode(buffer, songInfo.artists);
        }, buffer -> new SongInfo((String)ByteBufCodecs.STRING_UTF8.decode(buffer), (String)ByteBufCodecs.STRING_UTF8.decode(buffer), (Integer)ByteBufCodecs.VAR_INT.decode(buffer), (String)ByteBufCodecs.STRING_UTF8.decode(buffer), (Boolean)ByteBufCodecs.BOOL.decode(buffer), (Boolean)ByteBufCodecs.BOOL.decode(buffer), (List)ARTISTS_CODEC.decode(buffer)));
        @SerializedName(value="url")
        public String songUrl;
        @SerializedName(value="name")
        public String songName;
        @SerializedName(value="time_second")
        public int songTime;
        @SerializedName(value="trans_name")
        public String transName = "";
        @SerializedName(value="vip")
        public boolean vip = false;
        @SerializedName(value="read_only")
        public boolean readOnly = false;
        @SerializedName(value="artists")
        public List<String> artists = Lists.newArrayList();

        public SongInfo() {
        }

        public SongInfo(String songUrl, String songName, int songTime, String transName, boolean vip, boolean readOnly, List<String> artists) {
            this.songUrl = songUrl;
            this.songName = songName;
            this.songTime = songTime;
            this.transName = transName;
            this.vip = vip;
            this.readOnly = readOnly;
            this.artists = artists;
        }

        public SongInfo(String songUrl, String songName, int songTime, boolean readOnly) {
            this(songUrl, songName, songTime, "", false, readOnly, Collections.emptyList());
        }

        public SongInfo(NetEaseMusicSong pojo) {
            NetEaseMusicSong.Song song = pojo.getSong();
            if (song != null) {
                this.songUrl = String.format("https://music.163.com/song/media/outer/url?id=%d.mp3", song.getId());
                this.songName = song.getName();
                this.songTime = song.getDuration() / 1000;
                this.transName = song.getTransName();
                this.vip = song.needVip();
                this.artists = song.getArtists();
            }
        }

        public SongInfo(NetEaseMusicSong.Song song) {
            this.songUrl = String.format("https://music.163.com/song/media/outer/url?id=%d.mp3", song.getId());
            this.songName = song.getName();
            this.songTime = song.getDuration() / 1000;
            this.transName = song.getTransName();
            this.vip = song.needVip();
            this.artists = song.getArtists();
        }

        public SongInfo(NetEaseMusicList.Track track) {
            this.songUrl = String.format("https://music.163.com/song/media/outer/url?id=%d.mp3", track.getId());
            this.songName = track.getName();
            this.songTime = track.getDuration() / 1000;
            this.transName = track.getTransName();
            this.vip = track.needVip();
            this.artists = track.getArtists();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SongInfo)) {
                return false;
            }
            SongInfo other = (SongInfo)obj;
            return Objects.equals(this.songUrl, other.songUrl) && Objects.equals(this.songName, other.songName) && Objects.equals(this.songTime, other.songTime) && Objects.equals(this.transName, other.transName) && Objects.equals(this.vip, other.vip) && Objects.equals(this.artists, other.artists);
        }

        public int hashCode() {
            return Objects.hash(this.songUrl, this.songName, this.songTime, this.transName, this.vip, this.artists);
        }
    }
}

