/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.tileentity;

import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.block.BlockMusicPlayer;
import com.github.tartaricacid.netmusic.init.InitBlocks;
import com.github.tartaricacid.netmusic.inventory.MusicPlayerInv;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.MusicToClientMessage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TileEntityMusicPlayer
extends BlockEntity {
    public static final BlockEntityType<TileEntityMusicPlayer> TYPE = BlockEntityType.Builder.of(TileEntityMusicPlayer::new, (Block[])new Block[]{(Block)InitBlocks.MUSIC_PLAYER.get()}).build(null);
    private static final String CD_ITEM_TAG = "ItemStackCD";
    private static final String IS_PLAY_TAG = "IsPlay";
    private static final String CURRENT_TIME_TAG = "CurrentTime";
    private static final String SIGNAL_TAG = "RedStoneSignal";
    private final ItemStackHandler playerInv = new MusicPlayerInv(this);
    private boolean isPlay = false;
    private int currentTime;
    private boolean hasSignal = false;
    @Nullable
    public LyricRecord lyricRecord = null;

    public TileEntityMusicPlayer(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.getPersistentData().put(CD_ITEM_TAG, (Tag)this.playerInv.serializeNBT(provider));
        this.getPersistentData().putBoolean(IS_PLAY_TAG, this.isPlay);
        this.getPersistentData().putInt(CURRENT_TIME_TAG, this.currentTime);
        this.getPersistentData().putBoolean(SIGNAL_TAG, this.hasSignal);
        super.saveAdditional(compound, provider);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.playerInv.deserializeNBT(provider, this.getPersistentData().getCompound(CD_ITEM_TAG));
        this.isPlay = this.getPersistentData().getBoolean(IS_PLAY_TAG);
        this.currentTime = this.getPersistentData().getInt(CURRENT_TIME_TAG);
        this.hasSignal = this.getPersistentData().getBoolean(SIGNAL_TAG);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ItemStackHandler getPlayerInv() {
        return this.playerInv;
    }

    public IItemHandler createHandler() {
        BlockState state = this.getBlockState();
        if (state.getBlock() instanceof BlockMusicPlayer) {
            return this.playerInv;
        }
        return null;
    }

    public boolean isPlay() {
        return this.isPlay;
    }

    public void setPlay(boolean play) {
        this.isPlay = play;
    }

    public void setPlayToClient(ItemMusicCD.SongInfo info) {
        this.setCurrentTime(info.songTime * 20 + 64);
        this.isPlay = true;
        if (this.level != null && !this.level.isClientSide) {
            MusicToClientMessage msg = new MusicToClientMessage(this.worldPosition, info.songUrl, info.songTime, info.songName);
            NetworkHandler.sendToNearby(this.level, this.worldPosition, msg);
        }
    }

    public void markDirty() {
        this.setChanged();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void setCurrentTime(int time) {
        this.currentTime = time;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public boolean hasSignal() {
        return this.hasSignal;
    }

    public void setSignal(boolean signal) {
        this.hasSignal = signal;
    }

    public void tickTime() {
        if (this.currentTime > 0) {
            --this.currentTime;
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, TileEntityMusicPlayer te) {
        te.tickTime();
        if (0 < te.getCurrentTime() && te.getCurrentTime() < 16 && te.getCurrentTime() % 5 == 0) {
            if (((Boolean)blockState.getValue((Property)BlockMusicPlayer.CYCLE_DISABLE)).booleanValue()) {
                te.setPlay(false);
                te.markDirty();
            } else {
                ItemStack stackInSlot = te.getPlayerInv().getStackInSlot(0);
                if (stackInSlot.isEmpty()) {
                    return;
                }
                ItemMusicCD.SongInfo songInfo = ItemMusicCD.getSongInfo(stackInSlot);
                if (songInfo != null) {
                    te.setPlayToClient(songInfo);
                }
            }
        }
    }
}

