/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.api.pojo;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class NetEaseMusicSong {
    @SerializedName(value="code")
    private int code;
    @SerializedName(value="songs")
    private List<Song> song;

    @Nullable
    public Song getSong() {
        if (this.song.isEmpty()) {
            return null;
        }
        return this.song.get(0);
    }

    public int getCode() {
        return this.code;
    }

    public static class Song {
        @SerializedName(value="id")
        private long id;
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="transNames", alternate={"tns"})
        private List<String> transNames;
        @SerializedName(value="duration", alternate={"dt"})
        private int duration;
        @SerializedName(value="fee")
        private int fee;
        @SerializedName(value="artists", alternate={"ar"})
        private List<Artist> artists;

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getDuration() {
            return this.duration;
        }

        public String getTransName() {
            if (this.transNames == null || this.transNames.isEmpty()) {
                return "";
            }
            return this.transNames.get(0);
        }

        public boolean needVip() {
            return this.fee == 1;
        }

        public List<String> getArtists() {
            if (this.artists == null || this.artists.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList artistNames = Lists.newArrayList();
            this.artists.forEach(artist -> artistNames.add(artist.name));
            return artistNames;
        }
    }

    private static class Artist {
        @SerializedName(value="name")
        private String name;

        private Artist() {
        }
    }
}

