/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.audio;

import com.github.tartaricacid.netmusic.NetMusic;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public class ChunkedAudioStream
extends InputStream {
    public static final int CHUNK_SIZE = 81920;
    private InputStream currentStream;
    private long currentStart;
    private final URL url;
    private long contentLength = -1L;
    private final Proxy proxy;

    public ChunkedAudioStream(URL url, Proxy proxy) {
        this.url = url;
        this.currentStart = 0L;
        this.proxy = proxy == null ? Proxy.NO_PROXY : proxy;
        this.currentStream = this.openChunk(this.currentStart);
        this.contentLength = this.getContentLength();
    }

    @Override
    public int read() throws IOException {
        int b = this.currentStream.read();
        if (b == -1) {
            this.currentStart += 81920L;
            this.currentStream.close();
            this.currentStream = this.openChunk(this.currentStart);
            if (this.currentStream == null) {
                return -1;
            }
            b = this.currentStream.read();
        }
        return b;
    }

    private InputStream openChunk(long start) {
        try {
            if (this.contentLength != -1L && start >= this.contentLength) {
                return null;
            }
            URLConnection conn = this.url.openConnection(this.proxy);
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setRequestProperty("Range", "bytes=" + start + "-" + (start + 81920L - 1L));
            this.currentStart += conn.getContentLengthLong();
            return conn.getInputStream();
        }
        catch (IOException e) {
            NetMusic.LOGGER.error("Failed to open audio chunk at {}: {}", (Object)start, (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.currentStream == null) {
            return -1;
        }
        int bytesRead = this.currentStream.read(b, off, len);
        if (bytesRead == -1) {
            this.currentStream.close();
            this.currentStream = this.openChunk(this.currentStart);
            if (this.currentStream == null) {
                return -1;
            }
            bytesRead = this.currentStream.read(b, off, len);
        }
        return bytesRead;
    }

    private long getContentLength() {
        if (this.contentLength == -1L) {
            try {
                URLConnection conn = this.url.openConnection();
                this.contentLength = conn.getContentLengthLong();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.contentLength;
    }
}

