/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.audio;

import com.github.tartaricacid.netmusic.api.NetWorker;
import com.github.tartaricacid.netmusic.client.audio.ChunkedAudioStream;
import com.github.tartaricacid.netmusic.client.audio.MusicBufferedInputStream;
import com.github.tartaricacid.netmusic.config.GeneralConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.client.sounds.AudioStream;
import org.lwjgl.BufferUtils;

public class NetMusicAudioStream
implements AudioStream {
    private final AudioInputStream stream;
    private final int frameSize;
    private final byte[] frame;

    public NetMusicAudioStream(URL url) throws UnsupportedAudioFileException, IOException {
        Proxy proxy = NetWorker.getProxyFromConfig();
        MusicBufferedInputStream bufferedInputStream = new MusicBufferedInputStream(new ChunkedAudioStream(url, proxy));
        NetMusicAudioStream.skipID3(bufferedInputStream);
        AudioInputStream originalInputStream = AudioSystem.getAudioInputStream(bufferedInputStream);
        AudioFormat originalFormat = originalInputStream.getFormat();
        AudioFormat targetFormat = this.getTargetPCMAudioFormat(originalFormat);
        AudioInputStream targetInputStream = AudioSystem.getAudioInputStream(targetFormat, originalInputStream);
        targetFormat = (Boolean)GeneralConfig.ENABLE_STEREO.get() != false ? new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, originalFormat.getSampleRate(), 16, 1, 2, originalFormat.getSampleRate(), false) : new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, originalFormat.getSampleRate(), 16, 2, 4, originalFormat.getSampleRate(), false);
        this.stream = AudioSystem.getAudioInputStream(targetFormat, targetInputStream);
        this.frameSize = this.stream.getFormat().getFrameSize();
        this.frame = new byte[this.frameSize];
    }

    private AudioFormat getTargetPCMAudioFormat(AudioFormat originalFormat) {
        int sampleSizeInBits = originalFormat.getSampleSizeInBits();
        if (sampleSizeInBits == -1) {
            sampleSizeInBits = 16;
        }
        int frameSize = sampleSizeInBits / 8 * originalFormat.getChannels();
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, originalFormat.getSampleRate(), sampleSizeInBits, originalFormat.getChannels(), frameSize, originalFormat.getSampleRate(), false);
    }

    public AudioFormat m_6206_() {
        return this.stream.getFormat();
    }

    public ByteBuffer m_7118_(int size) throws IOException {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)size);
        int bytesRead = 0;
        int count = 0;
        do {
            if ((count = this.stream.read(this.frame)) == -1) continue;
            byteBuffer.put(this.frame);
        } while (count != -1 && (bytesRead += this.frameSize) < size);
        byteBuffer.flip();
        return byteBuffer;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    private static void skipID3(InputStream inputStream) throws IOException {
        inputStream.mark(10);
        byte[] header = new byte[10];
        int read = inputStream.read(header, 0, 10);
        if (read < 10) {
            inputStream.reset();
            return;
        }
        if (header[0] == 73 && header[1] == 68 && header[2] == 51) {
            int size = header[6] << 21 | header[7] << 14 | header[8] << 7 | header[9];
            int skipped = 0;
            int skip = 0;
            do {
                if ((skip = (int)inputStream.skip(size - skipped)) == 0) continue;
                skipped += skip;
            } while (skipped < size && skip != 0);
        } else {
            inputStream.reset();
        }
    }
}

