/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.compat.tlm.message;

import com.github.tartaricacid.netmusic.client.audio.MusicPlayManager;
import com.github.tartaricacid.netmusic.compat.tlm.chatbubble.LyricChatBubbleData;
import com.github.tartaricacid.netmusic.compat.tlm.client.audio.MaidNetMusicSound;
import com.github.tartaricacid.netmusic.config.GeneralConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class MaidMusicToClientMessage {
    private static final Pattern PATTERN = Pattern.compile("^.*?\\?id=(\\d+)\\.mp3$");
    private final int entityId;
    private final String url;
    private final int timeSecond;
    private final String songName;

    public MaidMusicToClientMessage(int entityId, String url, int timeSecond, String songName) {
        this.entityId = entityId;
        this.url = url;
        this.timeSecond = timeSecond;
        this.songName = songName;
    }

    public static void showLyric(EntityMaid maid, String url, String songName, int timeSecond) {
        Matcher matcher;
        if (((Boolean)GeneralConfig.ENABLE_MAID_LYRICS.get()).booleanValue() && url.startsWith("https://music.163.com/") && (matcher = PATTERN.matcher(url)).find()) {
            long musicId = Long.parseLong(matcher.group(1));
            int songTimeTick = timeSecond * 20 + 20;
            long gameTime = maid.m_9236_().m_46467_();
            LyricChatBubbleData bubbleData = new LyricChatBubbleData(musicId, songName, songTimeTick, gameTime);
            maid.getChatBubbleManager().addChatBubble((IChatBubbleData)bubbleData);
        }
    }

    public static MaidMusicToClientMessage decode(FriendlyByteBuf buf) {
        return new MaidMusicToClientMessage(buf.readInt(), buf.m_130277_(), buf.readInt(), buf.m_130277_());
    }

    public static void encode(MaidMusicToClientMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.m_130070_(message.url);
        buf.writeInt(message.timeSecond);
        buf.m_130070_(message.songName);
    }

    public static void handle(MaidMusicToClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> CompletableFuture.runAsync(() -> MaidMusicToClientMessage.onHandle(message), Util.m_183991_()));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(MaidMusicToClientMessage message) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityId);
        if (!(entity instanceof EntityMaid)) {
            return;
        }
        EntityMaid maid = (EntityMaid)entity;
        MusicPlayManager.play(message.url, message.songName, url -> new MaidNetMusicSound(maid, (URL)url, message.timeSecond));
    }
}

