/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.network.message;

import com.github.tartaricacid.netmusic.NetMusic;
import com.github.tartaricacid.netmusic.api.lyric.LyricParser;
import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.client.audio.MusicPlayManager;
import com.github.tartaricacid.netmusic.client.audio.NetMusicSound;
import com.github.tartaricacid.netmusic.config.GeneralConfig;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class MusicToClientMessage {
    private static final Pattern PATTERN = Pattern.compile("^.*?\\?id=(\\d+)\\.mp3$");
    private final BlockPos pos;
    private final String url;
    private final int timeSecond;
    private final String songName;

    public MusicToClientMessage(BlockPos pos, String url, int timeSecond, String songName) {
        this.pos = pos;
        this.url = url;
        this.timeSecond = timeSecond;
        this.songName = songName;
    }

    public static MusicToClientMessage decode(FriendlyByteBuf buf) {
        return new MusicToClientMessage(BlockPos.m_122022_((long)buf.readLong()), buf.m_130277_(), buf.readInt(), buf.m_130277_());
    }

    public static void encode(MusicToClientMessage message, FriendlyByteBuf buf) {
        buf.writeLong(message.pos.m_121878_());
        buf.m_130070_(message.url);
        buf.writeInt(message.timeSecond);
        buf.m_130070_(message.songName);
    }

    public static void handle(MusicToClientMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> CompletableFuture.runAsync(() -> MusicToClientMessage.onHandle(message), Util.m_183991_()));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(MusicToClientMessage message) {
        Matcher matcher;
        LyricRecord[] record = new LyricRecord[1];
        if (((Boolean)GeneralConfig.ENABLE_PLAYER_LYRICS.get()).booleanValue() && message.url.startsWith("https://music.163.com/") && (matcher = PATTERN.matcher(message.url)).find()) {
            long musicId = Long.parseLong(matcher.group(1));
            try {
                String lyric = NetMusic.NET_EASE_WEB_API.lyric(musicId);
                record[0] = LyricParser.parseLyric(lyric, message.songName);
            }
            catch (IOException e) {
                NetMusic.LOGGER.error((Object)e);
            }
        }
        MusicPlayManager.play(message.url, message.songName, url -> new NetMusicSound(message.pos, (URL)url, message.timeSecond, record[0]));
    }
}

