/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.audio;

import com.github.tartaricacid.netmusic.NetMusic;
import com.github.tartaricacid.netmusic.api.NetWorker;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class MusicPlayManager {
    public static final String ERROR_404 = "http://music.163.com/404";
    public static final String MUSIC_163_URL = "https://music.163.com/";
    private static final String LOCAL_FILE_PROTOCOL = "file";

    public static void play(String url, String songName, Function<URL, class_1113> sound) {
        String rawUrl = url;
        if (url.startsWith(MUSIC_163_URL)) {
            try {
                url = NetWorker.getRedirectUrl(url, NetMusic.NET_EASE_WEB_API.getRequestPropertyData());
            }
            catch (IOException e) {
                NetMusic.LOGGER.error("Failed to get redirect URL for: {}", (Object)url, (Object)e);
                return;
            }
        }
        if (url != null) {
            if (url.equals(ERROR_404)) {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    player.method_43496((class_2561)class_2561.method_43469((String)"message.netmusic.music_player.404", (Object[])new Object[]{rawUrl}).method_27692(class_124.field_1061));
                }
                NetMusic.LOGGER.info("Music not found: {}", (Object)rawUrl);
                return;
            }
            MusicPlayManager.playMusic(url, songName, sound);
        }
    }

    private static void playMusic(String url, String songName, Function<URL, class_1113> sound) {
        try {
            File file;
            URL urlFinal = new URL(url);
            if (urlFinal.getProtocol().equals(LOCAL_FILE_PROTOCOL) && !(file = new File(urlFinal.toURI())).exists()) {
                NetMusic.LOGGER.info("File not found: {}", (Object)url);
                return;
            }
            class_310.method_1551().method_20493(() -> {
                class_310.method_1551().method_1483().method_4873((class_1113)sound.apply(urlFinal));
                MusicPlayManager.setNowPlaying((class_2561)class_2561.method_43470((String)songName));
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            NetMusic.LOGGER.error("Malformed URL: {}", (Object)url, (Object)e);
        }
    }

    private static void setNowPlaying(class_2561 songName) {
        class_5250 mutableText = class_2561.method_43469((String)"record.nowPlaying", (Object[])new Object[]{songName});
        class_310.method_1551().field_1705.method_1758((class_2561)mutableText, true);
        class_310.method_1551().method_44713().method_37015((class_2561)mutableText);
    }
}

