/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.audio;

import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.audio.NetMusicAudioStream;
import com.github.tartaricacid.netmusic.init.InitSounds;
import com.github.tartaricacid.netmusic.tileentity.TileEntityMusicPlayer;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4234;
import net.minecraft.class_4237;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class NetMusicSound
extends class_1101 {
    private final URL songUrl;
    private final int tickTimes;
    private final class_2338 pos;
    @Nullable
    private final LyricRecord lyricRecord;
    private int tick;

    public NetMusicSound(class_2338 pos, URL songUrl, int timeSecond, @Nullable LyricRecord lyricRecord) {
        super(InitSounds.NET_MUSIC, class_3419.field_15247, class_1113.method_43221());
        this.songUrl = songUrl;
        this.field_5439 = (float)pos.method_10263() + 0.5f;
        this.field_5450 = (float)pos.method_10264() + 0.5f;
        this.field_5449 = (float)pos.method_10260() + 0.5f;
        this.tickTimes = timeSecond * 20;
        this.field_5442 = 4.0f;
        this.tick = 0;
        this.pos = pos;
        this.lyricRecord = lyricRecord;
    }

    public void method_16896() {
        class_2586 te;
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        ++this.tick;
        if (this.tick > this.tickTimes + 50) {
            te = world.method_8321(this.pos);
            if (te instanceof TileEntityMusicPlayer) {
                TileEntityMusicPlayer musicPlayer = (TileEntityMusicPlayer)te;
                musicPlayer.lyricRecord = null;
            }
            this.method_24876();
        } else if (world.method_8510() % 8L == 0L) {
            for (int i = 0; i < 2; ++i) {
                world.method_8406((class_2394)class_2398.field_11224, this.field_5439 - 0.5 + world.field_9229.method_43058(), this.field_5450 + world.field_9229.method_43058() + 1.0, this.field_5449 - 0.5 + world.field_9229.method_43058(), world.field_9229.method_43059(), world.field_9229.method_43059(), (double)world.field_9229.method_43048(3));
            }
        }
        if (this.lyricRecord != null) {
            this.lyricRecord.updateCurrentLine(this.tick);
        }
        if ((te = world.method_8321(this.pos)) instanceof TileEntityMusicPlayer) {
            TileEntityMusicPlayer musicPlay = (TileEntityMusicPlayer)te;
            if (!musicPlay.isPlay()) {
                musicPlay.lyricRecord = null;
                this.method_24876();
            } else {
                musicPlay.lyricRecord = this.lyricRecord;
            }
        } else {
            this.method_24876();
        }
    }

    public CompletableFuture<class_4234> getAudioStream(class_4237 soundBuffers, class_2960 id, boolean looping) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return new NetMusicAudioStream(this.songUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }, class_156.method_18349());
    }
}

