/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.command;

import com.github.tartaricacid.netmusic.config.MusicListManage;
import com.github.tartaricacid.netmusic.init.InitItems;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.networking.NetworkHandler;
import com.github.tartaricacid.netmusic.networking.message.GetMusicListMessage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.apache.commons.lang3.StringUtils;

public class NetMusicCommand {
    private static final String ROOT_NAME = "netmusic";
    private static final String RELOAD_NAME = "reload";
    private static final String GET_163_NAME = "get163";
    private static final String GET_163_CD_NAME = "get163cd";
    private static final String GET_DJ_CD_NAME = "getDJcd";
    private static final String SONG_LIST_ID = "song_list_id";
    private static final String SONG_ID = "song_id";
    private static final String DJ_SONG_ID = "dj_id";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder root = class_2170.method_9247((String)ROOT_NAME);
        LiteralArgumentBuilder get163List = class_2170.method_9247((String)GET_163_NAME);
        LiteralArgumentBuilder get163Song = class_2170.method_9247((String)GET_163_CD_NAME);
        LiteralArgumentBuilder reload = class_2170.method_9247((String)RELOAD_NAME);
        LiteralArgumentBuilder getDJSong = class_2170.method_9247((String)GET_DJ_CD_NAME);
        RequiredArgumentBuilder songListId = class_2170.method_9244((String)SONG_LIST_ID, (ArgumentType)LongArgumentType.longArg());
        RequiredArgumentBuilder songId = class_2170.method_9244((String)SONG_ID, (ArgumentType)LongArgumentType.longArg());
        RequiredArgumentBuilder djId = class_2170.method_9244((String)DJ_SONG_ID, (ArgumentType)LongArgumentType.longArg());
        root.then(get163List.then(songListId.executes(NetMusicCommand::getSongList)));
        root.then(get163Song.then(songId.executes(NetMusicCommand::getSong)));
        root.then(reload.executes(NetMusicCommand::reload));
        root.then(getDJSong.then(djId.executes(NetMusicCommand::getDJSong)));
        return root;
    }

    public static int getSong(CommandContext<class_2168> context) {
        try {
            long songId = LongArgumentType.getLong(context, (String)SONG_ID);
            ItemMusicCD.SongInfo songInfo = MusicListManage.get163Song(songId);
            if (StringUtils.isBlank((CharSequence)songInfo.songUrl) || StringUtils.isBlank((CharSequence)songInfo.songName)) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"gui.netmusic.cd_burner.get_info_error"));
                return 1;
            }
            class_1799 musicDisc = ItemMusicCD.setSongInfo(songInfo, InitItems.MUSIC_CD.method_7854());
            class_3222 serverPlayer = ((class_2168)context.getSource()).method_9207();
            boolean canPlaceIn = serverPlayer.method_31548().method_7394(musicDisc);
            if (canPlaceIn && musicDisc.method_7960()) {
                musicDisc.method_7939(1);
                class_1542 dropItem = serverPlayer.method_7328(musicDisc, false);
                if (dropItem != null) {
                    dropItem.method_6987();
                }
                serverPlayer.method_5770().method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((serverPlayer.method_59922().method_43057() - serverPlayer.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.field_7512.method_7623();
            } else {
                class_1542 dropItem = serverPlayer.method_7328(musicDisc, false);
                if (dropItem != null) {
                    dropItem.method_6975();
                    dropItem.method_6981((class_1297)serverPlayer);
                }
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.netmusic.music_cd.add163cd.success"), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.netmusic.music_cd.add163cd.fail"));
        }
        return 1;
    }

    private static int getSongList(CommandContext<class_2168> context) {
        try {
            long listId = LongArgumentType.getLong(context, (String)SONG_LIST_ID);
            class_3222 serverPlayer = ((class_2168)context.getSource()).method_9207();
            NetworkHandler.sendToClientPlayer(new GetMusicListMessage(listId), serverPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static int reload(CommandContext<class_2168> context) {
        try {
            class_3222 serverPlayer = ((class_2168)context.getSource()).method_9207();
            NetworkHandler.sendToClientPlayer(new GetMusicListMessage(-1L), serverPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static int getDJSong(CommandContext<class_2168> context) {
        try {
            long djId = LongArgumentType.getLong(context, (String)DJ_SONG_ID);
            ItemMusicCD.SongInfo songInfo = MusicListManage.getDjSong(djId);
            class_1799 musicDisc = ItemMusicCD.setSongInfo(songInfo, InitItems.MUSIC_CD.method_7854());
            class_3222 serverPlayer = ((class_2168)context.getSource()).method_9207();
            boolean canPlaceIn = serverPlayer.method_31548().method_7394(musicDisc);
            if (canPlaceIn && musicDisc.method_7960()) {
                musicDisc.method_7939(1);
                class_1542 dropItem = serverPlayer.method_7328(musicDisc, false);
                if (dropItem != null) {
                    dropItem.method_6987();
                }
                serverPlayer.method_5770().method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((serverPlayer.method_59922().method_43057() - serverPlayer.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.field_7512.method_7623();
            } else {
                class_1542 dropItem = serverPlayer.method_7328(musicDisc, false);
                if (dropItem != null) {
                    dropItem.method_6975();
                    dropItem.method_6981((class_1297)serverPlayer);
                }
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.netmusic.music_cd.addDJcd.success"), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.netmusic.music_cd.addDJcd.fail"));
        }
        return 1;
    }
}

