/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.gui;

import com.github.tartaricacid.netmusic.config.MusicListManage;
import com.github.tartaricacid.netmusic.inventory.CDBurnerMenu;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.ClientNetWorkHandler;
import com.github.tartaricacid.netmusic.networking.message.SetMusicIDMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class CDBurnerMenuScreen
extends class_465<CDBurnerMenu> {
    private static final class_2960 BG = class_2960.method_60655((String)"netmusic", (String)"textures/gui/cd_burner.png");
    private static final Pattern ID_REG = Pattern.compile("^\\d{4,}$");
    private static final Pattern DJ_ID_REG = Pattern.compile("^dj/(\\d+)$");
    private static final Pattern URL_1_REG = Pattern.compile("^https://music\\.163\\.com/song\\?id=(\\d+).*$");
    private static final Pattern URL_2_REG = Pattern.compile("^https://music\\.163\\.com/#/song\\?id=(\\d+).*$");
    private static final Pattern DJ_URL_1_REG = Pattern.compile("^https://music\\.163\\.com/dj\\?id=(\\d+).*$");
    private static final Pattern DJ_URL_2_REG = Pattern.compile("^https://music\\.163\\.com/#/dj\\?id=(\\d+).*$");
    private class_342 textField;
    private class_4286 readOnlyButton;
    private class_2561 tips = class_2561.method_43473();

    public CDBurnerMenuScreen(CDBurnerMenu handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2779 = 176;
        this.field_25270 = 82;
    }

    protected void method_25426() {
        super.method_25426();
        String perText = "";
        boolean focus = false;
        if (this.textField != null) {
            perText = this.textField.method_1882();
            focus = this.textField.method_25370();
        }
        this.textField = new class_342(this, this.field_22787.field_1772, this.field_2776 + 12, this.field_2800 + 18, 132, 16, (class_2561)class_2561.method_43473()){

            public void method_1867(String text) {
                Matcher matcher1 = URL_1_REG.matcher(text);
                if (matcher1.find()) {
                    String group = matcher1.group(1);
                    this.method_1852(group);
                    return;
                }
                Matcher matcher2 = URL_2_REG.matcher(text);
                if (matcher2.find()) {
                    String group = matcher2.group(1);
                    this.method_1852(group);
                    return;
                }
                Matcher matcher3 = DJ_URL_1_REG.matcher(text);
                if (matcher3.find()) {
                    String group = matcher3.group(1);
                    this.method_1852("dj/" + group);
                    return;
                }
                Matcher matcher4 = DJ_URL_2_REG.matcher(text);
                if (matcher4.find()) {
                    String group = matcher4.group(1);
                    this.method_1852("dj/" + group);
                    return;
                }
                super.method_1867(text);
            }
        };
        this.textField.method_1852(perText);
        this.textField.method_1858(false);
        this.textField.method_1880(19);
        this.textField.method_1868(15986656);
        this.textField.method_25365(focus);
        this.textField.method_1872(false);
        this.method_25429((class_364)this.textField);
        this.readOnlyButton = class_4286.method_54787((class_2561)class_2561.method_43471((String)"gui.netmusic.cd_burner.read_only"), (class_327)this.field_22793).method_54789(this.field_2776 + 66, this.field_2800 + 34).method_61131(80).method_54794(false).method_54788();
        this.method_37063((class_364)this.readOnlyButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.netmusic.cd_burner.craft"), button -> this.handleCraftButton()).method_46433(this.field_2776 + 7, this.field_2800 + 35).method_46437(55, 18).method_46431());
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = this.field_2776;
        int posY = this.field_2800;
        context.method_25302(BG, posX, posY, 0, 0, this.field_2792, this.field_2779);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.textField.method_25394(context, mouseX, mouseY, delta);
        if (StringUtils.isBlank((CharSequence)this.textField.method_1882()) && !this.textField.method_25370()) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.netmusic.cd_burner.id.tips").method_27692(class_124.field_1056), this.field_2776 + 12, this.field_2800 + 18, class_124.field_1080.method_532().intValue(), false);
        }
        context.method_51440(this.field_22793, (class_5348)this.tips, this.field_2776 + 8, this.field_2800 + 57, 135, 0xCF0000);
        this.method_2380(context, mouseX, mouseY);
    }

    public void method_25410(class_310 client, int width, int height) {
        String value = this.textField.method_1882();
        super.method_25410(client, width, height);
        this.textField.method_1852(value);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.textField.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.textField);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_22787.field_1724.method_7346();
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode) && this.textField.method_25370()) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_25415(String text, boolean override) {
        if (override) {
            this.textField.method_1852(text);
        } else {
            this.textField.method_1867(text);
        }
    }

    private void handleCraftButton() {
        class_1799 cd = ((CDBurnerMenu)this.method_17577()).getInput().method_7677();
        if (cd.method_7960()) {
            this.tips = class_2561.method_43471((String)"gui.netmusic.cd_burner.cd_is_empty");
            return;
        }
        ItemMusicCD.SongInfo songInfo = ItemMusicCD.getSongInfo(cd);
        if (songInfo != null && songInfo.readOnly) {
            this.tips = class_2561.method_43471((String)"gui.netmusic.cd_burner.cd_read_only");
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.textField.method_1882())) {
            this.tips = class_2561.method_43471((String)"gui.netmusic.cd_burner.no_music_id");
            return;
        }
        Matcher djMatcher = DJ_ID_REG.matcher(this.textField.method_1882());
        if (djMatcher.find()) {
            long djId = Long.parseLong(djMatcher.group(1));
            try {
                ItemMusicCD.SongInfo djSong = MusicListManage.getDjSong(djId);
                if (StringUtils.isBlank((CharSequence)djSong.songUrl) || StringUtils.isBlank((CharSequence)djSong.songName)) {
                    this.tips = class_2561.method_43471((String)"gui.netmusic.cd_burner.get_info_error");
                    return;
                }
                djSong.readOnly = this.readOnlyButton.method_20372();
                ClientNetWorkHandler.sendToServer(new SetMusicIDMessage(djSong));
                return;
            }
            catch (Exception e) {
                this.tips = class_2561.method_43471((String)"gui.netmusic.cd_burner.get_info_error");
                e.printStackTrace();
                return;
            }
        }
        if (ID_REG.matcher(this.textField.method_1882()).matches()) {
            long id = Long.parseLong(this.textField.method_1882());
            try {
                ItemMusicCD.SongInfo song = MusicListManage.get163Song(id);
                if (StringUtils.isBlank((CharSequence)song.songUrl) || StringUtils.isBlank((CharSequence)song.songName)) {
                    this.tips = class_2561.method_43471((String)"gui.netmusic.cd_burner.get_info_error");
                    return;
                }
                song.readOnly = this.readOnlyButton.method_20372();
                ClientNetWorkHandler.sendToServer(new SetMusicIDMessage(song));
            }
            catch (Exception e) {
                this.tips = class_2561.method_43471((String)"gui.netmusic.cd_burner.get_info_error");
                e.printStackTrace();
            }
        } else {
            this.tips = class_2561.method_43471((String)"gui.netmusic.cd_burner.music_id_error");
        }
    }
}

