/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.gui;

import com.github.tartaricacid.netmusic.inventory.ComputerMenu;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.ClientNetWorkHandler;
import com.github.tartaricacid.netmusic.networking.message.SetMusicIDMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import oshi.util.Util;

@Environment(value=EnvType.CLIENT)
public class ComputerMenuScreen
extends class_465<ComputerMenu> {
    private static final class_2960 BG = class_2960.method_60655((String)"netmusic", (String)"textures/gui/computer.png");
    private static final Pattern URL_HTTP_REG = Pattern.compile("(http|ftp|https)://[\\w\\-_]+(\\.[\\w\\-_]+)+([\\w\\-.,@?^=%&:/~+#]*[\\w\\-@?^=%&/~+#])?");
    private static final Pattern URL_FILE_REG = Pattern.compile("^[a-zA-Z]:\\\\(?:[^\\\\/:*?\"<>|\\r\\n]+\\\\)*[^\\\\/:*?\"<>|\\r\\n]*$");
    private static final Pattern TIME_REG = Pattern.compile("^\\d+$");
    private class_342 urlTextField;
    private class_342 nameTextField;
    private class_342 timeTextField;
    private class_4286 readOnlyButton;
    private class_2561 tips = class_2561.method_43473();

    public ComputerMenuScreen(ComputerMenu handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2779 = 216;
        this.field_25270 = this.field_2779 - 94;
    }

    protected void method_25426() {
        super.method_25426();
        this.initUrlEditBox();
        this.initNameEditBox();
        this.initTimeEditBox();
        this.readOnlyButton = class_4286.method_54787((class_2561)class_2561.method_43471((String)"gui.netmusic.cd_burner.read_only"), (class_327)this.field_22793).method_54789(this.field_2776 + 58, this.field_2800 + 55).method_61131(80).method_54794(false).method_54788();
        this.method_37063((class_364)this.readOnlyButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.netmusic.cd_burner.craft"), button -> this.handleCraftButton()).method_46433(this.field_2776 + 7, this.field_2800 + 78).method_46437(135, 18).method_46431());
    }

    private void initUrlEditBox() {
        String perText = "";
        boolean focus = false;
        if (this.urlTextField != null) {
            perText = this.urlTextField.method_1882();
            focus = this.urlTextField.method_25370();
        }
        this.urlTextField = new class_342(this.field_22793, this.field_2776 + 10, this.field_2800 + 18, 120, 16, (class_2561)class_2561.method_43470((String)"Music URL Box"));
        this.urlTextField.method_1852(perText);
        this.urlTextField.method_1858(false);
        this.urlTextField.method_1880(32500);
        this.urlTextField.method_1868(15986656);
        this.urlTextField.method_25365(focus);
        this.urlTextField.method_1872(false);
        this.method_25429((class_364)this.urlTextField);
    }

    private void initNameEditBox() {
        String preText = "";
        boolean focus = false;
        if (this.nameTextField != null) {
            preText = this.nameTextField.method_1882();
            focus = this.nameTextField.method_25370();
        }
        this.nameTextField = new class_342(this.field_22793, this.field_2776 + 10, this.field_2800 + 39, 120, 16, (class_2561)class_2561.method_43470((String)"Music Name Box"));
        this.nameTextField.method_1852(preText);
        this.nameTextField.method_1858(false);
        this.nameTextField.method_1880(256);
        this.nameTextField.method_1868(15986656);
        this.nameTextField.method_25365(focus);
        this.nameTextField.method_1872(false);
        this.method_25429((class_364)this.nameTextField);
    }

    private void initTimeEditBox() {
        String preText = "";
        boolean focus = false;
        if (this.timeTextField != null) {
            preText = this.timeTextField.method_1882();
            focus = this.timeTextField.method_25370();
        }
        this.timeTextField = new class_342(this.field_22793, this.field_2776 + 10, this.field_2800 + 61, 40, 16, (class_2561)class_2561.method_43470((String)"Music Time Box"));
        this.timeTextField.method_1852(preText);
        this.timeTextField.method_1858(false);
        this.timeTextField.method_1880(5);
        this.timeTextField.method_1868(15986656);
        this.timeTextField.method_25365(focus);
        this.timeTextField.method_1872(false);
        this.method_25429((class_364)this.timeTextField);
    }

    private void handleCraftButton() {
        class_1799 cd = ((ComputerMenu)this.method_17577()).getInput().method_7677();
        if (cd.method_7960()) {
            this.tips = class_2561.method_43471((String)"gui.netmusic.cd_burner.cd_is_empty");
            return;
        }
        ItemMusicCD.SongInfo songInfo = ItemMusicCD.getSongInfo(cd);
        if (songInfo != null && songInfo.readOnly) {
            this.tips = class_2561.method_43471((String)"gui.netmusic.cd_burner.cd_read_only");
            return;
        }
        String urlText = this.urlTextField.method_1882();
        if (Util.isBlank((String)urlText)) {
            this.tips = class_2561.method_43471((String)"gui.netmusic.computer.url.empty");
            return;
        }
        String nameText = this.nameTextField.method_1882();
        if (Util.isBlank((String)nameText)) {
            this.tips = class_2561.method_43471((String)"gui.netmusic.computer.name.empty");
            return;
        }
        String timeText = this.timeTextField.method_1882();
        if (Util.isBlank((String)timeText)) {
            this.tips = class_2561.method_43471((String)"gui.netmusic.computer.time.empty");
            return;
        }
        if (!TIME_REG.matcher(timeText).matches()) {
            this.tips = class_2561.method_43471((String)"gui.netmusic.computer.time.not_number");
            return;
        }
        int time = Integer.parseInt(timeText);
        if (URL_HTTP_REG.matcher(urlText).matches()) {
            ItemMusicCD.SongInfo song = new ItemMusicCD.SongInfo(urlText, nameText, time, this.readOnlyButton.method_20372());
            ClientNetWorkHandler.sendToServer(new SetMusicIDMessage(song));
            return;
        }
        if (URL_FILE_REG.matcher(urlText).matches()) {
            File file = Paths.get(urlText, new String[0]).toFile();
            if (!file.isFile()) {
                this.tips = class_2561.method_43471((String)"gui.netmusic.computer.url.local_file_error");
                return;
            }
            try {
                URL url = file.toURI().toURL();
                ItemMusicCD.SongInfo song = new ItemMusicCD.SongInfo(url.toString(), nameText, time, this.readOnlyButton.method_20372());
                ClientNetWorkHandler.sendToServer(new SetMusicIDMessage(song));
                return;
            }
            catch (MalformedURLException e) {
                e.fillInStackTrace();
            }
        }
        this.tips = class_2561.method_43471((String)"gui.netmusic.computer.url.error");
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = this.field_2776;
        int posY = this.field_2800;
        context.method_25302(BG, posX, posY, 0, 0, this.field_2792, this.field_2779);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.urlTextField.method_25394(context, mouseX, mouseY, delta);
        this.nameTextField.method_25394(context, mouseX, mouseY, delta);
        this.timeTextField.method_25394(context, mouseX, mouseY, delta);
        if (Util.isBlank((String)this.urlTextField.method_1882()) && !this.urlTextField.method_25370()) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.netmusic.computer.url.tips").method_27692(class_124.field_1056), this.field_2776 + 12, this.field_2800 + 18, class_124.field_1080.method_532().intValue(), false);
        }
        if (Util.isBlank((String)this.nameTextField.method_1882()) && !this.nameTextField.method_25370()) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.netmusic.computer.name.tips").method_27692(class_124.field_1056), this.field_2776 + 12, this.field_2800 + 39, class_124.field_1080.method_532().intValue(), false);
        }
        if (Util.isBlank((String)this.timeTextField.method_1882()) && !this.timeTextField.method_25370()) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.netmusic.computer.time.tips").method_27692(class_124.field_1056), this.field_2776 + 12, this.field_2800 + 61, class_124.field_1080.method_532().intValue(), false);
        }
        context.method_51440(this.field_22793, (class_5348)this.tips, this.field_2776 + 8, this.field_2800 + 100, 162, 0xCF0000);
        this.method_2380(context, mouseX, mouseY);
    }

    public void method_25410(class_310 client, int width, int height) {
        String urlValue = this.urlTextField.method_1882();
        String nameValue = this.nameTextField.method_1882();
        String timeValue = this.timeTextField.method_1882();
        super.method_25410(client, width, height);
        this.urlTextField.method_1852(urlValue);
        this.nameTextField.method_1852(nameValue);
        this.timeTextField.method_1852(timeValue);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.urlTextField.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.urlTextField);
            return true;
        }
        if (this.nameTextField.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.nameTextField);
            return true;
        }
        if (this.timeTextField.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.timeTextField);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.field_22787.field_1724.method_7346();
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode) && (this.urlTextField.method_25370() || this.nameTextField.method_25370() || this.timeTextField.method_25370())) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_25415(String text, boolean override) {
        if (override) {
            this.urlTextField.method_1852(text);
            this.nameTextField.method_1852(text);
            this.timeTextField.method_1852(text);
        } else {
            this.urlTextField.method_1867(text);
            this.nameTextField.method_1867(text);
            this.timeTextField.method_1867(text);
        }
    }
}

