/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.item;

import com.github.tartaricacid.netmusic.api.pojo.NetEaseMusicList;
import com.github.tartaricacid.netmusic.api.pojo.NetEaseMusicSong;
import com.github.tartaricacid.netmusic.init.InitDataComponent;
import com.github.tartaricacid.netmusic.init.InitItems;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.StringUtils;

public class ItemMusicCD
extends class_1792 {
    public ItemMusicCD(class_1792.class_1793 settings) {
        super(settings);
    }

    public static SongInfo getSongInfo(class_1799 stack) {
        if (stack.method_7909() == InitItems.MUSIC_CD) {
            return (SongInfo)stack.method_57824(InitDataComponent.SONG_INFO);
        }
        return null;
    }

    public static class_1799 setSongInfo(SongInfo info, class_1799 stack) {
        if (stack.method_7909() == InitItems.MUSIC_CD) {
            stack.method_57379(InitDataComponent.SONG_INFO, (Object)info);
        }
        return stack;
    }

    public class_2561 method_7864(class_1799 stack) {
        SongInfo info = ItemMusicCD.getSongInfo(stack);
        if (info != null) {
            Object name = info.songName;
            if (info.vip) {
                name = (String)name + " \u00a74\u00a7l[VIP]";
            }
            if (info.readOnly) {
                class_5250 readOnlyText = class_2561.method_43471((String)"tooltips.netmusic.cd.read_only").method_27692(class_124.field_1054);
                return class_2561.method_43470((String)name).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)readOnlyText);
            }
            return class_2561.method_43470((String)name);
        }
        return super.method_7864(stack);
    }

    private String getSongTime(int songTime) {
        int min = songTime / 60;
        int sec = songTime % 60;
        String minStr = min <= 9 ? "0" + min : "" + min;
        String secStr = sec <= 9 ? "0" + sec : "" + sec;
        String format = class_2477.method_10517().method_48307("tooltips.netmusic.cd.time.format");
        return String.format(format, minStr, secStr);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        SongInfo info = ItemMusicCD.getSongInfo(stack);
        String prefix = "\u00a7a\u258d \u00a77";
        String delimiter = ": ";
        class_2477 language = class_2477.method_10517();
        if (info != null) {
            String text;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{info.transName})) {
                text = "\u00a7a\u258d \u00a77" + language.method_48307("tooltips.netmusic.cd.trans_name") + ": \u00a76" + info.transName;
                tooltip.add((class_2561)class_2561.method_43470((String)text));
            }
            if (info.artists != null && !info.artists.isEmpty()) {
                String artistNames = StringUtils.join(info.artists, (String)" | ");
                String text2 = "\u00a7a\u258d \u00a77" + language.method_48307("tooltips.netmusic.cd.artists") + ": \u00a73" + artistNames;
                tooltip.add((class_2561)class_2561.method_43470((String)text2));
            }
            text = "\u00a7a\u258d \u00a77" + language.method_48307("tooltips.netmusic.cd.time") + ": \u00a75" + this.getSongTime(info.songTime);
            tooltip.add((class_2561)class_2561.method_43470((String)text));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltips.netmusic.cd.empty").method_27692(class_124.field_1061));
        }
    }

    public static class SongInfo {
        public static final Codec<SongInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("url").forGetter(i -> i.songUrl), (App)Codec.STRING.fieldOf("name").forGetter(i -> i.songName), (App)Codec.INT.fieldOf("time_second").forGetter(i -> i.songTime), (App)Codec.STRING.optionalFieldOf("trans_name", (Object)"").forGetter(i -> i.transName), (App)Codec.BOOL.optionalFieldOf("vip", (Object)false).forGetter(i -> i.vip), (App)Codec.BOOL.optionalFieldOf("readOnly", (Object)false).forGetter(i -> i.readOnly), (App)Codec.STRING.listOf().optionalFieldOf("artists", Collections.emptyList()).forGetter(i -> i.artists)).apply((Applicative)instance, SongInfo::new));
        private static final class_9139<ByteBuf, List<String>> ARTISTS_CODEC = class_9135.method_56376(ArrayList::new, (class_9139)class_9135.field_48554);
        public static final class_9139<ByteBuf, SongInfo> STREAM_CODEC = class_9139.method_56437((buffer, songInfo) -> {
            class_9135.field_48554.encode(buffer, (Object)songInfo.songUrl);
            class_9135.field_48554.encode(buffer, (Object)songInfo.songName);
            class_9135.field_48550.encode(buffer, (Object)songInfo.songTime);
            class_9135.field_48554.encode(buffer, (Object)songInfo.transName);
            class_9135.field_48547.encode(buffer, (Object)songInfo.vip);
            class_9135.field_48547.encode(buffer, (Object)songInfo.readOnly);
            ARTISTS_CODEC.encode(buffer, songInfo.artists);
        }, buffer -> new SongInfo((String)class_9135.field_48554.decode(buffer), (String)class_9135.field_48554.decode(buffer), (Integer)class_9135.field_48550.decode(buffer), (String)class_9135.field_48554.decode(buffer), (Boolean)class_9135.field_48547.decode(buffer), (Boolean)class_9135.field_48547.decode(buffer), (List)ARTISTS_CODEC.decode(buffer)));
        @SerializedName(value="url")
        public String songUrl;
        @SerializedName(value="name")
        public String songName;
        @SerializedName(value="time_second")
        public int songTime;
        @SerializedName(value="trans_name")
        public String transName = "";
        @SerializedName(value="vip")
        public boolean vip = false;
        @SerializedName(value="read_only")
        public boolean readOnly = false;
        @SerializedName(value="artists")
        public List<String> artists = Lists.newArrayList();

        public SongInfo() {
        }

        public SongInfo(String songUrl, String songName, int songTime, String transName, boolean vip, boolean readOnly, List<String> artists) {
            this.songUrl = songUrl;
            this.songName = songName;
            this.songTime = songTime;
            this.transName = transName;
            this.vip = vip;
            this.readOnly = readOnly;
            this.artists = artists;
        }

        public SongInfo(String songUrl, String songName, int songTime, boolean readOnly) {
            this(songUrl, songName, songTime, "", false, readOnly, Collections.emptyList());
        }

        public SongInfo(NetEaseMusicSong pojo) {
            NetEaseMusicSong.Song song = pojo.getSong();
            if (song != null) {
                this.songUrl = String.format("https://music.163.com/song/media/outer/url?id=%d.mp3", song.getId());
                this.songName = song.getName();
                this.songTime = song.getDuration() / 1000;
                this.transName = song.getTransName();
                this.vip = song.needVip();
                this.artists = song.getArtists();
            }
        }

        public SongInfo(NetEaseMusicSong.Song song) {
            this.songUrl = String.format("https://music.163.com/song/media/outer/url?id=%d.mp3", song.getId());
            this.songName = song.getName();
            this.songTime = song.getDuration() / 1000;
            this.transName = song.getTransName();
            this.vip = song.needVip();
            this.artists = song.getArtists();
        }

        public SongInfo(NetEaseMusicList.Track track) {
            this.songUrl = String.format("https://music.163.com/song/media/outer/url?id=%d.mp3", track.getId());
            this.songName = track.getName();
            this.songTime = track.getDuration() / 1000;
            this.transName = track.getTransName();
            this.vip = track.needVip();
            this.artists = track.getArtists();
        }

        public SongInfo(class_2487 nbt) {
            this.songUrl = nbt.method_10558("url");
            this.songName = nbt.method_10558("name");
            this.songTime = nbt.method_10550("time");
            if (nbt.method_10573("trans_name", 8)) {
                this.transName = nbt.method_10558("trans_name");
            }
            if (nbt.method_10573("vip", 1)) {
                this.vip = nbt.method_10577("vip");
            }
            if (nbt.method_10573("read_only", 1)) {
                this.readOnly = nbt.method_10577("read_only");
            }
            if (nbt.method_10573("artists", 9)) {
                this.artists = nbt.method_10554("artists", 8).stream().map(class_2520::method_10714).toList();
            }
        }

        public static SongInfo deserializeNBT(class_2487 nbt) {
            return new SongInfo(nbt);
        }

        public static void serializeNBT(SongInfo info, class_2487 nbt) {
            nbt.method_10582("url", info.songUrl);
            nbt.method_10582("name", info.songName);
            nbt.method_10569("time", info.songTime);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{info.transName})) {
                nbt.method_10582("trans_name", info.transName);
            }
            nbt.method_10556("vip", info.vip);
            nbt.method_10556("read_only", info.readOnly);
            if (info.artists != null && !info.artists.isEmpty()) {
                class_2499 nbtList = new class_2499();
                info.artists.forEach(artist -> nbtList.add((Object)class_2519.method_23256((String)artist)));
                nbt.method_10566("artists", (class_2520)nbtList);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SongInfo)) {
                return false;
            }
            SongInfo other = (SongInfo)obj;
            return Objects.equals(this.songUrl, other.songUrl) && Objects.equals(this.songName, other.songName) && Objects.equals(this.songTime, other.songTime) && Objects.equals(this.transName, other.transName) && Objects.equals(this.vip, other.vip) && Objects.equals(this.readOnly, other.readOnly) && Objects.equals(this.artists, other.artists);
        }

        public int hashCode() {
            return Objects.hash(this.songUrl, this.songName, this.songTime, this.transName, this.vip, this.readOnly, this.artists);
        }
    }
}

