/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.receiver;

import com.github.tartaricacid.netmusic.NetMusic;
import com.github.tartaricacid.netmusic.api.lyric.LyricParser;
import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.audio.MusicPlayManager;
import com.github.tartaricacid.netmusic.audio.NetMusicSound;
import com.github.tartaricacid.netmusic.config.GeneralConfig;
import com.github.tartaricacid.netmusic.networking.message.MusicToClientMessage;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;

@Environment(value=EnvType.CLIENT)
public class MusicToClientMessageReceiver
implements ClientPlayNetworking.PlayPayloadHandler<MusicToClientMessage> {
    private static final Pattern PATTERN = Pattern.compile("^.*?\\?id=(\\d+)\\.mp3$");

    public void receive(MusicToClientMessage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> CompletableFuture.runAsync(() -> {
            Matcher matcher;
            LyricRecord[] record = new LyricRecord[1];
            if (GeneralConfig.ENABLE_PLAYER_LYRICS.booleanValue() && message.getUrl().startsWith("https://music.163.com/") && (matcher = PATTERN.matcher(message.getUrl())).find()) {
                long musicId = Long.parseLong(matcher.group(1));
                try {
                    String lyric = NetMusic.NET_EASE_WEB_API.lyric(musicId);
                    record[0] = LyricParser.parseLyric(lyric, message.getSongName());
                }
                catch (IOException e) {
                    NetMusic.LOGGER.error((Object)e);
                }
            }
            MusicPlayManager.play(message.getUrl(), message.getSongName(), url -> new NetMusicSound(message.getPos(), (URL)url, message.getTimeSecond(), record[0]));
        }, class_156.method_18349()));
    }
}

