/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.renderer;

import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.config.GeneralConfig;
import com.github.tartaricacid.netmusic.model.ModelMusicPlayer;
import com.github.tartaricacid.netmusic.tileentity.TileEntityMusicPlayer;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_8828;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class MusicPlayerRenderer
implements class_827<TileEntityMusicPlayer> {
    public static ModelMusicPlayer<?> MODEL;
    public static final class_2960 TEXTURE;
    public static MusicPlayerRenderer instance;
    private final class_327 font;
    private final class_824 dispatcher;

    public MusicPlayerRenderer(class_5614.class_5615 context) {
        MODEL = new ModelMusicPlayer(context.method_32140(ModelMusicPlayer.LAYER));
        instance = this;
        this.font = context.method_32143();
        this.dispatcher = context.method_32139();
    }

    public void render(TileEntityMusicPlayer entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2350 facing = (class_2350)entity.method_11010().method_11654((class_2769)class_2383.field_11177);
        class_1799 cd = entity.method_5438(0);
        class_630 disc = MODEL.getDiscBone();
        boolean bl = disc.field_3665 = !entity.method_5442();
        if (!cd.method_7960() && entity.isPlay()) {
            disc.field_3675 = (float)(0.15707963267948966 * ((double)System.currentTimeMillis() / 50.0 % 40.0));
        }
        this.renderMusicPlayer(matrices, vertexConsumers, light, facing);
        this.renderLyric(entity, matrices, vertexConsumers, light);
    }

    public void renderMusicPlayer(class_4587 matrixStack, class_4597 vertexConsumers, int combinedLight, class_2350 facing) {
        matrixStack.method_22903();
        matrixStack.method_22905(0.75f, 0.75f, 0.75f);
        matrixStack.method_22904(0.6666666666666666, 1.5, 0.6666666666666666);
        switch (facing) {
            case field_11035: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11034: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
                break;
            }
            case field_11039: {
                matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
        }
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)TEXTURE));
        MODEL.method_2828(matrixStack, buffer, combinedLight, class_4608.field_21444, -1);
        matrixStack.method_22909();
    }

    private void renderLyric(TileEntityMusicPlayer te, class_4587 matrixStack, class_4597 vertexConsumers, int combinedLight) {
        if (!GeneralConfig.ENABLE_PLAYER_LYRICS.booleanValue()) {
            return;
        }
        LyricRecord lyricRecord = te.lyricRecord;
        if (lyricRecord == null) {
            return;
        }
        Int2ObjectSortedMap<String> lyrics = lyricRecord.getLyrics();
        if (lyrics == null || lyrics.isEmpty()) {
            return;
        }
        if (!te.isPlay()) {
            te.lyricRecord = null;
            return;
        }
        class_4184 camera = this.dispatcher.field_4344;
        class_124 currentLyricColor = class_124.field_1080;
        class_124 transLyricColor = class_124.field_1068;
        float y = 0.5f;
        String lyric = (String)lyrics.get(lyrics.firstIntKey());
        class_5250 currentLine = StringUtils.isNotBlank((CharSequence)lyric) ? class_2561.method_43470((String)lyric) : class_2561.method_43473();
        class_5250 translatedLine = null;
        Int2ObjectSortedMap<String> transLyrics = lyricRecord.getTransLyrics();
        if (transLyrics != null && !transLyrics.isEmpty()) {
            String transLyric = (String)transLyrics.get(transLyrics.firstIntKey());
            if (StringUtils.isNotBlank((CharSequence)transLyric)) {
                translatedLine = class_2561.method_43470((String)transLyric);
            }
            y += 0.5f;
        } else {
            currentLyricColor = class_124.field_1068;
        }
        currentLine = currentLine.method_27692(currentLyricColor);
        matrixStack.method_22903();
        matrixStack.method_22904(0.5, 1.625, 0.5);
        matrixStack.method_22907(class_7833.field_40715.rotationDegrees(camera.method_19330()));
        matrixStack.method_22907(class_7833.field_40713.rotationDegrees(-camera.method_19329()));
        matrixStack.method_22905(-0.025f, -0.025f, 0.025f);
        float opacity = class_310.method_1551().field_1690.method_19343(0.25f);
        int bgColor = (int)(opacity * 255.0f) << 24;
        if (!currentLine.method_10851().equals((Object)class_8828.field_46625)) {
            float currentLineWidth = -this.font.method_27525((class_5348)currentLine) / 2;
            this.font.method_30882((class_2561)currentLine, currentLineWidth, -y, -1, false, matrixStack.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, bgColor, combinedLight);
        }
        if (translatedLine != null) {
            float translatedLineWidth = -this.font.method_27525((class_5348)translatedLine) / 2;
            translatedLine = translatedLine.method_27692(transLyricColor);
            this.font.method_30882((class_2561)translatedLine, translatedLineWidth, -y - 12.0f, -1, false, matrixStack.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, bgColor, combinedLight);
        }
        matrixStack.method_22909();
    }

    public boolean rendersOutsideBoundingBox(TileEntityMusicPlayer blockEntity) {
        return true;
    }

    static {
        TEXTURE = class_2960.method_60655((String)"netmusic", (String)"textures/block/music_player.png");
    }
}

