/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.tileentity;

import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.block.BlockMusicPlayer;
import com.github.tartaricacid.netmusic.init.InitBlocks;
import com.github.tartaricacid.netmusic.inventory.MusicPlayerInv;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.networking.NetworkHandler;
import com.github.tartaricacid.netmusic.networking.message.MusicToClientMessage;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class TileEntityMusicPlayer
extends class_2586
implements MusicPlayerInv {
    public static final class_2591<TileEntityMusicPlayer> TYPE = class_2591.class_2592.method_20528(TileEntityMusicPlayer::new, (class_2248[])new class_2248[]{InitBlocks.MUSIC_PLAYER}).method_11034(null);
    private static final String IS_PLAY_TAG = "IsPlay";
    private static final String CURRENT_TIME_TAG = "CurrentTime";
    private static final String SIGNAL_TAG = "RedStoneSignal";
    private final class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private boolean isPlay = false;
    private int currentTime;
    private boolean hasSignal = false;
    @Nullable
    public LyricRecord lyricRecord = null;

    public TileEntityMusicPlayer(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @Override
    public class_1799 method_5438(int slot) {
        return (class_1799)this.getItems().get(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.getItems(), (int)slot, (int)amount);
        this.method_5431();
        return result;
    }

    @Override
    public class_1799 method_5441(int slot) {
        class_1799 result = class_1262.method_5428(this.getItems(), (int)slot);
        this.method_5431();
        return result;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return true;
    }

    @Override
    public void method_5448() {
        this.getItems().clear();
    }

    public void setCurrentTime(int currentTime) {
        this.currentTime = currentTime;
        this.method_5431();
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public boolean hasSignal() {
        return this.hasSignal;
    }

    public void setSignal(boolean signal) {
        this.hasSignal = signal;
    }

    public void tickTime() {
        if (this.currentTime > 0) {
            --this.currentTime;
        }
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, TileEntityMusicPlayer te) {
        te.tickTime();
        if (0 < te.getCurrentTime() && te.getCurrentTime() < 16 && te.getCurrentTime() % 5 == 0) {
            if (((Boolean)blockState.method_11654((class_2769)BlockMusicPlayer.CYCLE_DISABLE)).booleanValue()) {
                te.setPlay(false);
                te.method_5431();
            } else {
                class_1799 stackInSlot = (class_1799)te.getItems().getFirst();
                if (stackInSlot.method_7960()) {
                    return;
                }
                ItemMusicCD.SongInfo songInfo = ItemMusicCD.getSongInfo(stackInSlot);
                if (songInfo != null) {
                    te.setPlayToClient(songInfo);
                }
            }
        }
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)registryLookup);
        this.isPlay = nbt.method_10577(IS_PLAY_TAG);
        this.currentTime = nbt.method_10550(CURRENT_TIME_TAG);
        this.hasSignal = nbt.method_10577(SIGNAL_TAG);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)registryLookup);
        nbt.method_10556(IS_PLAY_TAG, this.isPlay);
        nbt.method_10569(CURRENT_TIME_TAG, this.currentTime);
        nbt.method_10556(SIGNAL_TAG, this.hasSignal);
        super.method_11007(nbt, registryLookup);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public boolean isPlay() {
        return this.isPlay;
    }

    public void setPlay(boolean play) {
        this.isPlay = play;
        this.method_5431();
    }

    public void setPlayToClient(ItemMusicCD.SongInfo info) {
        this.setCurrentTime(info.songTime * 20 + 64);
        this.setPlay(true);
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            MusicToClientMessage msg = new MusicToClientMessage(this.field_11867, info.songUrl, info.songTime, info.songName);
            NetworkHandler.sendToNearBy(this.field_11863, this.field_11867, msg);
        }
    }

    public void method_5431() {
        super.method_5431();
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        this.field_11863.method_8413(this.field_11867, state, state, 0);
    }
}

