/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards;

import org.bukkit.plugin.java.JavaPlugin;
import org.flare.bumbleShards.commands.BShardsCommand;
import org.flare.bumbleShards.listeners.InventoryClickShardGUIListener;
import org.flare.bumbleShards.listeners.KillUpgradeListener;
import org.flare.bumbleShards.listeners.PlayerJoinLifeAndShardListener;
import org.flare.bumbleShards.lives.LifeManager;
import org.flare.bumbleShards.shards.BreezeShard;
import org.flare.bumbleShards.shards.CreeperShard;
import org.flare.bumbleShards.shards.DolphinShard;
import org.flare.bumbleShards.shards.EnderShard;
import org.flare.bumbleShards.shards.HorseShard;
import org.flare.bumbleShards.shards.RavagerShard;
import org.flare.bumbleShards.shards.VexShard;
import org.flare.bumbleShards.shards.WardenShard;
import org.flare.bumbleShards.shards.WitchShard;
import org.flare.bumbleShards.shards.WitherShard;
import org.flare.bumbleShards.utils.MessageUtil;

public class BumbleShards
extends JavaPlugin {
    private LifeManager lifeManager;
    private KillUpgradeListener killUpgradeListener;

    public void onEnable() {
        this.saveDefaultConfig();
        MessageUtil.init(this);
        this.lifeManager = new LifeManager(this);
        new BShardsCommand(this, this.lifeManager);
        new PlayerJoinLifeAndShardListener(this, this.lifeManager);
        this.killUpgradeListener = new KillUpgradeListener(this);
        new InventoryClickShardGUIListener(this);
        new BreezeShard(this);
        new DolphinShard(this);
        new RavagerShard(this);
        new EnderShard(this);
        new VexShard(this);
        new HorseShard(this);
        new WitchShard(this);
        new WitherShard(this);
        new WardenShard(this);
        new CreeperShard(this);
        this.getLogger().info("BumbleShards enabled successfully!");
    }

    public void onDisable() {
        if (this.lifeManager != null) {
            this.lifeManager.saveData();
        }
        if (this.killUpgradeListener != null) {
            this.killUpgradeListener.saveKillCounts();
        }
        this.saveConfig();
        this.getLogger().info("BumbleShards disabled!");
    }
}

