/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.flare.bumbleShards.BumbleShards;
import org.flare.bumbleShards.lives.LifeManager;
import org.flare.bumbleShards.shards.ShardItemFactory;
import org.flare.bumbleShards.utils.MessageUtil;

public class BShardsCommand
implements CommandExecutor,
TabCompleter {
    private final BumbleShards plugin;
    private final LifeManager lifeManager;

    public BShardsCommand(BumbleShards plugin, LifeManager lifeManager) {
        this.plugin = plugin;
        this.lifeManager = lifeManager;
        Objects.requireNonNull(plugin.getCommand("bshards")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(plugin.getCommand("bshards")).setTabCompleter((TabCompleter)this);
    }

    private String safeArgLower(String[] args, int index) {
        if (args == null || args.length <= index || args[index] == null) {
            return "";
        }
        return args[index].toLowerCase(Locale.ROOT);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String subCommand = this.safeArgLower(args, 0);
        if (subCommand.isEmpty()) {
            sender.sendMessage(MessageUtil.get("messages.usage"));
            return true;
        }
        switch (subCommand) {
            case "reload": {
                if (!sender.hasPermission(this.plugin.getConfig().getString("permissions.reload"))) {
                    sender.sendMessage(MessageUtil.get("messages.no-permission"));
                    return true;
                }
                this.plugin.reloadConfig();
                sender.sendMessage(MessageUtil.get("messages.config-reloaded"));
                break;
            }
            case "give": {
                if (!sender.hasPermission(this.plugin.getConfig().getString("permissions.give"))) {
                    sender.sendMessage(MessageUtil.get("messages.no-permission"));
                    return true;
                }
                this.handleGive(sender, args);
                break;
            }
            case "list": {
                if (!sender.hasPermission(this.plugin.getConfig().getString("permissions.list"))) {
                    sender.sendMessage(MessageUtil.get("messages.no-permission"));
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage(MessageUtil.get("messages.players-only"));
                    return true;
                }
                Player p = (Player)sender;
                this.openShardsGUI(p);
                break;
            }
            case "lives": {
                if (!sender.hasPermission(this.plugin.getConfig().getString("permissions.lives"))) {
                    sender.sendMessage(MessageUtil.get("messages.no-permission"));
                    return true;
                }
                this.handleLives(sender, args);
                break;
            }
            default: {
                sender.sendMessage(MessageUtil.get("messages.usage"));
            }
        }
        return true;
    }

    private void handleGive(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(MessageUtil.get("messages.give-usage"));
            return;
        }
        Player target = Bukkit.getPlayerExact((String)args[1]);
        if (target == null) {
            sender.sendMessage(MessageUtil.get("messages.player-not-found").replace("%player%", args[1]));
            return;
        }
        String shardName = this.safeArgLower(args, 2);
        int tier = 1;
        if (args.length >= 4) {
            try {
                tier = Math.max(1, Math.min(3, Integer.parseInt(args[3])));
            }
            catch (NumberFormatException ignored) {
                sender.sendMessage(MessageUtil.get("messages.invalid-tier"));
                return;
            }
        }
        if (shardName.equals("all")) {
            for (String s : ShardItemFactory.getAllShardNames()) {
                target.getInventory().addItem(new ItemStack[]{ShardItemFactory.createShardByNameWithTier(s, tier)});
            }
            sender.sendMessage(MessageUtil.get("messages.gave-all").replace("%tier%", String.valueOf(tier)).replace("%player%", target.getName()));
            return;
        }
        if (!ShardItemFactory.getAllShardNames().contains(shardName)) {
            sender.sendMessage(MessageUtil.get("messages.invalid-shard").replace("%shard%", shardName));
            return;
        }
        ItemStack shardItem = ShardItemFactory.createShardByNameWithTier(shardName, tier);
        target.getInventory().addItem(new ItemStack[]{shardItem});
        sender.sendMessage(MessageUtil.get("messages.gave-one").replace("%shard%", shardItem.getItemMeta().getDisplayName()).replace("%tier%", String.valueOf(tier)).replace("%player%", target.getName()));
    }

    private void handleLives(CommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(MessageUtil.get("messages.lives-usage"));
            return;
        }
        Player target = Bukkit.getPlayerExact((String)args[1]);
        if (target == null) {
            sender.sendMessage(MessageUtil.get("messages.player-not-found").replace("%player%", args[1]));
            return;
        }
        String action = this.safeArgLower(args, 2);
        if (action.equals("add")) {
            int amt = this.parseAmount(args, sender);
            if (amt < 0) {
                return;
            }
            this.lifeManager.addLife(target, amt);
            this.lifeManager.saveData();
        } else if (action.equals("remove")) {
            int amt = this.parseAmount(args, sender);
            if (amt < 0) {
                return;
            }
            this.lifeManager.removeLife(target, amt);
            this.lifeManager.saveData();
        } else if (action.equals("set")) {
            int amt = this.parseAmount(args, sender);
            if (amt < 0) {
                return;
            }
            this.lifeManager.setLives(target, amt);
            this.lifeManager.saveData();
        } else if (action.equals("view")) {
            sender.sendMessage(MessageUtil.get("messages.lives-view").replace("%player%", target.getName()).replace("%lives%", String.valueOf(this.lifeManager.getLives(target))));
        } else {
            sender.sendMessage(MessageUtil.get("messages.lives-usage"));
        }
    }

    private void openShardsGUI(Player player) {
        int size = this.plugin.getConfig().getInt("settings.gui.size", 27);
        String title = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("settings.gui.title", "&6&lShard List"));
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)title);
        for (String name : ShardItemFactory.getAllShardNames()) {
            inv.addItem(new ItemStack[]{ShardItemFactory.createShardByNameWithTier(name, 1)});
        }
        player.openInventory(inv);
    }

    private int parseAmount(String[] args, CommandSender sender) {
        if (args.length < 4) {
            sender.sendMessage(MessageUtil.get("messages.amount-required"));
            return -1;
        }
        try {
            return Integer.parseInt(args[3]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(MessageUtil.get("messages.invalid-number").replace("%input%", args[3]));
            return -1;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        ArrayList<String> lowerArgs = new ArrayList<String>();
        for (String arg : args) {
            lowerArgs.add(arg == null ? "" : arg.toLowerCase(Locale.ROOT));
        }
        if (args.length == 1) {
            return this.partial((String)lowerArgs.get(0), Arrays.asList("reload", "give", "list", "lives"));
        }
        if (args.length == 2 && (((String)lowerArgs.get(0)).equals("give") || ((String)lowerArgs.get(0)).equals("lives"))) {
            return this.partial(args[1], Bukkit.getOnlinePlayers().stream().map(Player::getName).toList());
        }
        if (args.length == 3 && ((String)lowerArgs.get(0)).equals("give")) {
            ArrayList<String> opts = new ArrayList<String>(ShardItemFactory.getAllShardNames());
            opts.add("all");
            return this.partial((String)lowerArgs.get(2), opts);
        }
        if (args.length == 4 && ((String)lowerArgs.get(0)).equals("give")) {
            return this.partial((String)lowerArgs.get(3), Arrays.asList("1", "2", "3"));
        }
        if (args.length == 3 && ((String)lowerArgs.get(0)).equals("lives")) {
            return this.partial((String)lowerArgs.get(2), Arrays.asList("add", "remove", "set", "view"));
        }
        return Collections.emptyList();
    }

    private List<String> partial(String input, List<String> options) {
        if (input.isEmpty()) {
            return options;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : options) {
            if (!s.toLowerCase(Locale.ROOT).startsWith(input.toLowerCase(Locale.ROOT))) continue;
            result.add(s);
        }
        return result;
    }
}

