/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.flare.bumbleShards.BumbleShards;
import org.flare.bumbleShards.shards.ShardItemFactory;
import org.flare.bumbleShards.utils.MessageUtil;
import org.flare.bumbleShards.utils.ShardUtils;

public class KillUpgradeListener
implements Listener {
    private final BumbleShards plugin;
    private final Map<UUID, Integer> killCounts = new HashMap<UUID, Integer>();

    public KillUpgradeListener(BumbleShards plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.loadKillCounts();
    }

    @EventHandler
    public void onKill(PlayerDeathEvent event) {
        Player killer = event.getEntity().getKiller();
        Player victim = event.getEntity();
        if (killer == null || killer.equals((Object)victim)) {
            return;
        }
        UUID killerId = killer.getUniqueId();
        int kills = this.killCounts.getOrDefault(killerId, 0) + 1;
        this.killCounts.put(killerId, kills);
        this.saveKillCounts();
        killer.sendMessage(MessageUtil.get("messages.kill-count").replace("%kills%", String.valueOf(kills)));
        if (kills == 10) {
            this.upgradeShards(killer, 1, 2);
            killer.sendMessage(MessageUtil.get("messages.tier-upgrade-10"));
        }
        if (kills == 20) {
            this.upgradeShards(killer, 2, 3);
            killer.sendMessage(MessageUtil.get("messages.tier-upgrade-20"));
        }
    }

    private void upgradeShards(Player player, int fromTier, int toTier) {
        for (int slot = 0; slot < player.getInventory().getSize(); ++slot) {
            String shardName;
            int tier;
            ItemStack item = player.getInventory().getItem(slot);
            if (!ShardUtils.isAnyShard(item) || (tier = ShardUtils.getTier(item)) != fromTier || (shardName = ShardUtils.getBaseName(item)) == null) continue;
            ItemStack upgraded = ShardItemFactory.createShardByNameWithTier(shardName, toTier);
            player.getInventory().setItem(slot, upgraded);
        }
        player.updateInventory();
    }

    public void saveKillCounts() {
        for (Map.Entry<UUID, Integer> entry : this.killCounts.entrySet()) {
            this.plugin.getConfig().set("playerKills." + entry.getKey().toString(), (Object)entry.getValue());
        }
        this.plugin.saveConfig();
    }

    public void loadKillCounts() {
        if (this.plugin.getConfig().contains("playerKills")) {
            for (String key : this.plugin.getConfig().getConfigurationSection("playerKills").getKeys(false)) {
                UUID uuid = UUID.fromString(key);
                int kills = this.plugin.getConfig().getInt("playerKills." + key, 0);
                this.killCounts.put(uuid, kills);
            }
        }
    }
}

