/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.listeners;

import java.util.List;
import java.util.Random;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.flare.bumbleShards.BumbleShards;
import org.flare.bumbleShards.lives.LifeManager;
import org.flare.bumbleShards.shards.ShardItemFactory;
import org.flare.bumbleShards.utils.CooldownManager;
import org.flare.bumbleShards.utils.MessageUtil;
import org.flare.bumbleShards.utils.ShardUtils;

public class PlayerJoinLifeAndShardListener
implements Listener {
    private final BumbleShards plugin;
    private final LifeManager lifeManager;
    private final boolean showActionbar;
    private final Random random = new Random();

    public PlayerJoinLifeAndShardListener(BumbleShards plugin, LifeManager lifeManager) {
        this.plugin = plugin;
        this.lifeManager = lifeManager;
        this.showActionbar = plugin.getConfig().getBoolean("settings.lives.display-actionbar", true);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        boolean firstJoin;
        final Player player = event.getPlayer();
        boolean bl = firstJoin = !this.lifeManager.hasPlayerData(player);
        if (firstJoin) {
            this.lifeManager.setLives(player, this.lifeManager.getDefaultLives());
            this.lifeManager.saveData();
            player.sendMessage(MessageUtil.get("messages.first-join").replace("%lives%", String.valueOf(this.lifeManager.getDefaultLives())));
            List<String> shardNames = ShardItemFactory.getAllShardNames();
            String randomShardName = shardNames.get(this.random.nextInt(shardNames.size()));
            player.getInventory().addItem(new ItemStack[]{ShardItemFactory.createShardByNameWithTier(randomShardName, 1)});
            player.sendMessage(MessageUtil.get("messages.first-join-shard").replace("%shard%", this.capitalize(randomShardName)).replace("%tier%", "1"));
        }
        if (this.showActionbar) {
            new BukkitRunnable(){

                public void run() {
                    String key;
                    long rem;
                    if (!player.isOnline()) {
                        this.cancel();
                        return;
                    }
                    int lives = PlayerJoinLifeAndShardListener.this.lifeManager.getLives(player);
                    String cdValue = "0";
                    ItemStack hand = player.getInventory().getItemInMainHand();
                    if (ShardUtils.isAnyShard(hand) && (rem = CooldownManager.getRemaining(key = ChatColor.stripColor((String)hand.getItemMeta().getDisplayName()).split(" ")[0].toLowerCase(), player.getUniqueId()) / 1000L) > 0L) {
                        cdValue = String.valueOf(rem);
                    }
                    String msg = MessageUtil.get("messages.lives-actionbar").replace("%lives%", String.valueOf(lives)).replace("%maxlives%", String.valueOf(PlayerJoinLifeAndShardListener.this.lifeManager.getMaxLives())).replace("%cooldown%", cdValue);
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)msg));
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        }
    }

    private String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }
}

