/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.lives;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.BanList;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.flare.bumbleShards.utils.MessageUtil;

public class LifeManager {
    private final JavaPlugin plugin;
    private final Map<UUID, Integer> playerLives = new HashMap<UUID, Integer>();
    private final int defaultLives;
    private final int maxLives;
    private final boolean banOnZero;

    public LifeManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.defaultLives = plugin.getConfig().getInt("settings.lives.initial", 10);
        this.maxLives = plugin.getConfig().getInt("settings.lives.max", 15);
        this.banOnZero = plugin.getConfig().getBoolean("settings.lives.ban-on-zero", true);
        this.loadData();
    }

    public void loadData() {
        this.playerLives.clear();
        if (this.plugin.getConfig().contains("playerLives")) {
            for (String key : this.plugin.getConfig().getConfigurationSection("playerLives").getKeys(false)) {
                UUID uuid = UUID.fromString(key);
                int lives = this.plugin.getConfig().getInt("playerLives." + key, this.defaultLives);
                this.playerLives.put(uuid, lives);
            }
        }
    }

    public void saveData() {
        for (Map.Entry<UUID, Integer> entry : this.playerLives.entrySet()) {
            this.plugin.getConfig().set("playerLives." + String.valueOf(entry.getKey()), (Object)entry.getValue());
        }
        this.plugin.saveConfig();
    }

    public int getLives(Player player) {
        return this.playerLives.getOrDefault(player.getUniqueId(), this.defaultLives);
    }

    public void setLives(Player player, int lives) {
        this.playerLives.put(player.getUniqueId(), Math.max(0, Math.min(lives, this.maxLives)));
    }

    public void addLife(Player player, int amount) {
        this.setLives(player, this.getLives(player) + amount);
        player.sendMessage(MessageUtil.get("messages.lives-gained").replace("%lives%", String.valueOf(this.getLives(player))));
    }

    public void removeLife(Player player, int amount) {
        int newLives = Math.max(0, this.getLives(player) - amount);
        this.setLives(player, newLives);
        player.sendMessage(MessageUtil.get("messages.lives-lost").replace("%lives%", String.valueOf(newLives)));
        if (newLives == 0 && this.banOnZero) {
            String reason = MessageUtil.get("messages.ban-reason");
            this.plugin.getServer().getBanList(BanList.Type.NAME).addBan(player.getName(), reason, null, null);
            if (player.isOnline()) {
                player.kickPlayer(reason);
            }
        }
    }

    public int getMaxLives() {
        return this.maxLives;
    }

    public int getDefaultLives() {
        return this.defaultLives;
    }

    public boolean hasPlayerData(Player player) {
        return this.playerLives.containsKey(player.getUniqueId());
    }
}

