/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.shards;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.flare.bumbleShards.BumbleShards;
import org.flare.bumbleShards.utils.CooldownManager;
import org.flare.bumbleShards.utils.MessageUtil;
import org.flare.bumbleShards.utils.ShardUtils;

public class CreeperShard
implements Listener {
    private final int cooldownSeconds;
    private final Random rand = new Random();

    public CreeperShard(BumbleShards plugin) {
        this.cooldownSeconds = plugin.getConfig().getInt("cooldowns.creeper", 15);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        if (!this.validClick(e) || !ShardUtils.isShard(e.getItem(), "Creeper Shard")) {
            return;
        }
        Player p = e.getPlayer();
        e.setCancelled(true);
        String shardKey = "creeper";
        if (CooldownManager.isOnCooldown(shardKey, p.getUniqueId())) {
            long cd = CooldownManager.getRemaining(shardKey, p.getUniqueId()) / 1000L;
            p.sendMessage(MessageUtil.get("messages.cooldown").replace("%seconds%", String.valueOf(cd)));
            return;
        }
        CooldownManager.setCooldown(shardKey, p.getUniqueId(), (long)this.cooldownSeconds * 1000L);
        int tier = ShardUtils.getTier(e.getItem());
        int count = tier == 1 ? 3 : (tier == 2 ? 5 : 8);
        int fuse = 40;
        Location base = p.getLocation();
        World w = base.getWorld();
        for (int i = 0; i < count; ++i) {
            double ox = (this.rand.nextDouble() - 0.5) * 4.0;
            double oz = (this.rand.nextDouble() - 0.5) * 4.0;
            Location spawn = base.clone().add(ox, 1.0, oz);
            w.spawn(spawn, TNTPrimed.class, tnt -> {
                tnt.setFuseTicks(fuse);
                tnt.setSource((Entity)p);
                tnt.setVelocity(new Vector(this.rand.nextDouble() - 0.5, 0.4, this.rand.nextDouble() - 0.5));
            });
        }
        p.sendMessage(MessageUtil.get("messages.shard-activated").replace("%shard%", "Creeper Shard").replace("%tier%", String.valueOf(tier)));
    }

    private boolean validClick(PlayerInteractEvent e) {
        return e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK;
    }
}

