/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.shards;

import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockIterator;
import org.flare.bumbleShards.BumbleShards;
import org.flare.bumbleShards.utils.CooldownManager;
import org.flare.bumbleShards.utils.MessageUtil;
import org.flare.bumbleShards.utils.ShardUtils;

public class EnderShard
implements Listener {
    private final int cooldownSeconds;

    public EnderShard(BumbleShards plugin) {
        this.cooldownSeconds = plugin.getConfig().getInt("cooldowns.ender");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        if (!this.validClick(e) || !ShardUtils.isShard(e.getItem(), "Ender Shard")) {
            return;
        }
        Player p = e.getPlayer();
        e.setCancelled(true);
        String shardKey = "ender";
        if (CooldownManager.isOnCooldown(shardKey, p.getUniqueId())) {
            long cd = CooldownManager.getRemaining(shardKey, p.getUniqueId()) / 1000L;
            p.sendMessage(MessageUtil.get("messages.cooldown").replace("%seconds%", String.valueOf(cd)));
            return;
        }
        CooldownManager.setCooldown(shardKey, p.getUniqueId(), (long)this.cooldownSeconds * 1000L);
        int tier = ShardUtils.getTier(e.getItem());
        int range = tier == 1 ? 15 : (tier == 2 ? 25 : 35);
        try {
            BlockIterator it = new BlockIterator((LivingEntity)p, range);
            Location loc = null;
            while (it.hasNext()) {
                loc = it.next().getLocation();
            }
            if (loc != null) {
                p.teleport(loc.add(0.0, 1.0, 0.0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        p.sendMessage(MessageUtil.get("messages.shard-activated").replace("%shard%", "Ender Shard").replace("%tier%", String.valueOf(tier)));
    }

    private boolean validClick(PlayerInteractEvent e) {
        return e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK;
    }
}

