/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.shards;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.flare.bumbleShards.BumbleShards;
import org.flare.bumbleShards.utils.CooldownManager;
import org.flare.bumbleShards.utils.MessageUtil;
import org.flare.bumbleShards.utils.ShardUtils;

public class RavagerShard
implements Listener {
    private final int cooldownSeconds;

    public RavagerShard(BumbleShards plugin) {
        this.cooldownSeconds = plugin.getConfig().getInt("cooldowns.ravager");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        double rad;
        if (!this.validClick(e) || !ShardUtils.isShard(e.getItem(), "Ravager Shard")) {
            return;
        }
        Player p = e.getPlayer();
        e.setCancelled(true);
        String shardKey = "ravager";
        if (CooldownManager.isOnCooldown(shardKey, p.getUniqueId())) {
            long cd = CooldownManager.getRemaining(shardKey, p.getUniqueId()) / 1000L;
            p.sendMessage(MessageUtil.get("messages.cooldown").replace("%seconds%", String.valueOf(cd)));
            return;
        }
        CooldownManager.setCooldown(shardKey, p.getUniqueId(), (long)this.cooldownSeconds * 1000L);
        int tier = ShardUtils.getTier(e.getItem());
        double d = tier == 1 ? 5.0 : (rad = tier == 2 ? 8.0 : 10.0);
        double str = tier == 1 ? 1.5 : (tier == 2 ? 2.5 : 3.5);
        Vector look = p.getLocation().getDirection().normalize();
        for (Entity ent : p.getNearbyEntities(rad, rad, rad)) {
            Vector to;
            if (!(ent instanceof LivingEntity) || ent.equals((Object)p) || !((to = ent.getLocation().toVector().subtract(p.getLocation().toVector()).normalize()).dot(look) > 0.6)) continue;
            Vector kb = to.multiply(str);
            kb.setY(0.5);
            ent.setVelocity(kb);
        }
        p.sendMessage(MessageUtil.get("messages.shard-activated").replace("%shard%", "Ravager Shard").replace("%tier%", String.valueOf(tier)));
    }

    private boolean validClick(PlayerInteractEvent e) {
        return e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK;
    }
}

