/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.shards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShardItemFactory {
    public static final Material SHARD_MATERIAL = Material.ECHO_SHARD;
    private static final List<String> baseShardNames = Arrays.asList("breeze", "dolphin", "ravager", "ender", "vex", "horse", "witch", "wither", "warden", "creeper");
    private static final Map<String, Integer> modelDataMap = Map.of("breeze", 1001, "dolphin", 1002, "ravager", 1003, "ender", 1004, "vex", 1005, "horse", 1006, "witch", 1007, "wither", 1008, "warden", 1009, "creeper", 1010);

    public static ItemStack createShardByNameWithTier(String name, int tier) {
        if (!baseShardNames.contains(name = name.toLowerCase())) {
            return null;
        }
        String displayName = ShardItemFactory.capitalize(name) + " Shard";
        ItemStack shard = new ItemStack(SHARD_MATERIAL);
        ItemMeta meta = shard.getItemMeta();
        if (meta == null) {
            return null;
        }
        meta.setDisplayName(ShardItemFactory.generateDisplayName(name, tier));
        List<String> lore = ShardItemFactory.generateLore(name, tier);
        meta.setLore(lore);
        meta.setCustomModelData(modelDataMap.getOrDefault(name, 0));
        shard.setItemMeta(meta);
        return shard;
    }

    public static List<String> getAllShardNames() {
        return Collections.unmodifiableList(baseShardNames);
    }

    private static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String generateDisplayName(String baseName, int tier) {
        String colorCode = switch (baseName) {
            case "breeze" -> "\u00a7b";
            case "dolphin" -> "\u00a73";
            case "ravager" -> "\u00a7c";
            case "ender" -> "\u00a75";
            case "vex" -> "\u00a7f";
            case "horse" -> "\u00a7e";
            case "witch" -> "\u00a7d";
            case "wither" -> "\u00a78";
            case "warden" -> "\u00a79";
            case "creeper" -> "\u00a7a";
            default -> "\u00a77";
        };
        return colorCode + ShardItemFactory.capitalize(baseName) + " Shard";
    }

    private static List<String> generateLore(String baseName, int tier) {
        ArrayList<String> lore = new ArrayList<String>();
        String description = switch (baseName) {
            case "breeze" -> "Jump Boost + Wind Charges";
            case "dolphin" -> "Dolphin's Grace boost";
            case "ravager" -> "Charge and knockback";
            case "ender" -> "Teleport short range";
            case "vex" -> "Invisibility + Flight";
            case "horse" -> "Speed boost";
            case "witch" -> "Regeneration effect";
            case "wither" -> "Strength effect";
            case "warden" -> "Blindness to enemies";
            case "creeper" -> "Explosive TNT summon";
            default -> "A mysterious shard";
        };
        lore.add("\u00a77" + description);
        lore.add("\u00a78Tier: " + tier);
        return lore;
    }
}

