/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.shards;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.flare.bumbleShards.BumbleShards;
import org.flare.bumbleShards.utils.CooldownManager;
import org.flare.bumbleShards.utils.MessageUtil;
import org.flare.bumbleShards.utils.ShardUtils;

public class VexShard
implements Listener {
    private final int cooldownSeconds;
    private final BumbleShards plugin;

    public VexShard(BumbleShards plugin) {
        this.plugin = plugin;
        this.cooldownSeconds = plugin.getConfig().getInt("cooldowns.vex");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        if (!this.validClick(e) || !ShardUtils.isShard(e.getItem(), "Vex Shard")) {
            return;
        }
        Player p = e.getPlayer();
        e.setCancelled(true);
        String shardKey = "vex";
        if (CooldownManager.isOnCooldown(shardKey, p.getUniqueId())) {
            long cd = CooldownManager.getRemaining(shardKey, p.getUniqueId()) / 1000L;
            p.sendMessage(MessageUtil.get("messages.cooldown").replace("%seconds%", String.valueOf(cd)));
            return;
        }
        CooldownManager.setCooldown(shardKey, p.getUniqueId(), (long)this.cooldownSeconds * 1000L);
        int tier = ShardUtils.getTier(e.getItem());
        int duration = tier == 1 ? 200 : (tier == 2 ? 400 : 600);
        p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, duration, 0, false, false));
        p.setAllowFlight(true);
        p.setFlying(true);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            p.setFlying(false);
            p.setAllowFlight(false);
        }, (long)duration);
        p.sendMessage(MessageUtil.get("messages.shard-activated").replace("%shard%", "Vex Shard").replace("%tier%", String.valueOf(tier)));
    }

    private boolean validClick(PlayerInteractEvent e) {
        return e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK;
    }
}

