/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.shards;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.flare.bumbleShards.BumbleShards;
import org.flare.bumbleShards.utils.CooldownManager;
import org.flare.bumbleShards.utils.MessageUtil;
import org.flare.bumbleShards.utils.ShardUtils;

public class WardenShard
implements Listener {
    private final int cooldownSeconds;

    public WardenShard(BumbleShards plugin) {
        this.cooldownSeconds = plugin.getConfig().getInt("cooldowns.warden");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        int radius;
        if (!this.validClick(e) || !ShardUtils.isShard(e.getItem(), "Warden Shard")) {
            return;
        }
        Player p = e.getPlayer();
        e.setCancelled(true);
        String shardKey = "warden";
        if (CooldownManager.isOnCooldown(shardKey, p.getUniqueId())) {
            long cd = CooldownManager.getRemaining(shardKey, p.getUniqueId()) / 1000L;
            p.sendMessage(MessageUtil.get("messages.cooldown").replace("%seconds%", String.valueOf(cd)));
            return;
        }
        CooldownManager.setCooldown(shardKey, p.getUniqueId(), (long)this.cooldownSeconds * 1000L);
        int tier = ShardUtils.getTier(e.getItem());
        int n = tier == 1 ? 5 : (radius = tier == 2 ? 10 : 15);
        int duration = tier == 1 ? 40 : (tier == 2 ? 80 : 120);
        int amplifier = tier - 1;
        for (Entity ent : p.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            if (!(ent instanceof LivingEntity) || ent.equals((Object)p)) continue;
            ((LivingEntity)ent).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, duration, amplifier, false, false));
        }
        p.sendMessage(MessageUtil.get("messages.shard-activated").replace("%shard%", "Warden Shard").replace("%tier%", String.valueOf(tier)));
    }

    private boolean validClick(PlayerInteractEvent e) {
        return e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK;
    }
}

