/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.shards;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.flare.bumbleShards.BumbleShards;
import org.flare.bumbleShards.utils.CooldownManager;
import org.flare.bumbleShards.utils.MessageUtil;
import org.flare.bumbleShards.utils.ShardUtils;

public class WitchShard
implements Listener {
    private final int cooldownSeconds;

    public WitchShard(BumbleShards plugin) {
        this.cooldownSeconds = plugin.getConfig().getInt("cooldowns.witch");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        if (!this.validClick(e) || !ShardUtils.isShard(e.getItem(), "Witch Shard")) {
            return;
        }
        Player p = e.getPlayer();
        e.setCancelled(true);
        String shardKey = "witch";
        if (CooldownManager.isOnCooldown(shardKey, p.getUniqueId())) {
            long cd = CooldownManager.getRemaining(shardKey, p.getUniqueId()) / 1000L;
            p.sendMessage(MessageUtil.get("messages.cooldown").replace("%seconds%", String.valueOf(cd)));
            return;
        }
        CooldownManager.setCooldown(shardKey, p.getUniqueId(), (long)this.cooldownSeconds * 1000L);
        int tier = ShardUtils.getTier(e.getItem());
        int dur = tier == 1 ? 200 : (tier == 2 ? 400 : 600);
        int amp = tier - 1;
        p.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, dur, amp));
        p.sendMessage(MessageUtil.get("messages.shard-activated").replace("%shard%", "Witch Shard").replace("%tier%", String.valueOf(tier)));
    }

    private boolean validClick(PlayerInteractEvent e) {
        return e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK;
    }
}

