/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CooldownManager {
    private static final Map<String, Map<UUID, Long>> cooldowns = new HashMap<String, Map<UUID, Long>>();

    public static void setCooldown(String shard, UUID playerId, long ms) {
        cooldowns.computeIfAbsent(shard.toLowerCase(), k -> new HashMap()).put(playerId, System.currentTimeMillis() + ms);
    }

    public static long getRemaining(String shard, UUID playerId) {
        Map<UUID, Long> map = cooldowns.get(shard.toLowerCase());
        if (map == null) {
            return 0L;
        }
        return Math.max(0L, map.getOrDefault(playerId, 0L) - System.currentTimeMillis());
    }

    public static boolean isOnCooldown(String shard, UUID playerId) {
        return CooldownManager.getRemaining(shard, playerId) > 0L;
    }
}

