/*
 * Decompiled with CFR 0.152.
 */
package org.flare.bumbleShards.utils;

import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.flare.bumbleShards.shards.ShardItemFactory;

public class ShardUtils {
    public static boolean isShard(ItemStack item, String displayName) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return false;
        }
        String strippedName = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
        return strippedName.equalsIgnoreCase(ChatColor.stripColor((String)displayName));
    }

    public static boolean isAnyShard(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return false;
        }
        String strippedName = ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).toLowerCase();
        return ShardItemFactory.getAllShardNames().stream().anyMatch(strippedName::contains);
    }

    public static int getTier(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return 1;
        }
        for (String line : item.getItemMeta().getLore()) {
            String lower = ChatColor.stripColor((String)line).toLowerCase();
            if (lower.contains("tier: 3")) {
                return 3;
            }
            if (!lower.contains("tier: 2")) continue;
            return 2;
        }
        return 1;
    }

    public static String getBaseName(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return null;
        }
        String strippedName = ChatColor.stripColor((String)item.getItemMeta().getDisplayName()).toLowerCase();
        for (String base : ShardItemFactory.getAllShardNames()) {
            if (!strippedName.contains(base.toLowerCase())) continue;
            return base;
        }
        return null;
    }

    public static boolean isShardType(ItemStack item, String shardBaseName) {
        String base = ShardUtils.getBaseName(item);
        return base != null && base.equalsIgnoreCase(shardBaseName);
    }
}

