/*
 * Decompiled with CFR 0.152.
 */
package jp.nlaocs.rotateSk.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Packet Based Yaw/Pitch")
@Description(value={"Allows you to change pitch and yaw without rolling back the player's view. It is possible to get Pitch/Yaw, but there is no advantage to using this Expression."})
@Examples(value={"set player's packet based pitch to 45", "add 5 to player's packet based yaw", "subtract 3 from player's packet based pitch"})
public class ExprPacketYawPitch
extends SimplePropertyExpression<Player, Number> {
    private boolean isYaw;
    private static final int version;
    private static final Class<?> RELATIVE_CLASS;
    private static final Set<?> FIELD_ALL;
    private static final Object FIELD_Y_ROT;
    private static final Object FIELD_X_ROT;
    private static Object FIELD_ROTATE_DELTA;
    private static Constructor<?> POSITION_MOVE_ROTATION;
    private static Object Vec3_ZERO;

    private static String getVersionClassName() {
        if (version == 2) {
            return "Relative";
        }
        if (version == 1) {
            return "RelativeMovement";
        }
        return "EnumPlayerTeleportFlags";
    }

    public Number convert(Player player) {
        if (this.isYaw) {
            float yaw = player.getLocation().getYaw();
            return Float.valueOf(((yaw + 180.0f) % 360.0f + 360.0f) % 360.0f - 180.0f);
        }
        return Float.valueOf(player.getLocation().getPitch());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return null;
        }
        return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
    }

    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        if (delta == null || delta.length == 0) {
            return;
        }
        if (!(delta[0] instanceof Number)) {
            return;
        }
        if (mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return;
        }
        float value = ((Number)delta[0]).floatValue();
        if (mode == Changer.ChangeMode.REMOVE) {
            value = -value;
        }
        ProtocolManager pm = ProtocolLibrary.getProtocolManager();
        PacketContainer packet = pm.createPacket(PacketType.Play.Server.POSITION);
        HashSet relative = new HashSet(FIELD_ALL);
        if (mode == Changer.ChangeMode.SET) {
            Object rotFlag = this.isYaw ? FIELD_Y_ROT : FIELD_X_ROT;
            relative.remove(rotFlag);
        }
        if (version >= 2) {
            relative.remove(FIELD_ROTATE_DELTA);
            try {
                Object posMoveRot = POSITION_MOVE_ROTATION.newInstance(Vec3_ZERO, Vec3_ZERO, Float.valueOf(this.isYaw ? value : 0.0f), Float.valueOf(this.isYaw ? 0.0f : value));
                packet.getModifier().write(1, posMoveRot);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create PositionMoveRotation instance", e);
            }
        } else {
            packet.getFloat().write(this.isYaw ? 0 : 1, (Object)Float.valueOf(value));
        }
        packet.getSpecificModifier(Set.class).write(0, relative);
        this.sendToAll(pm, packet, (Player[])this.getExpr().getArray(event));
    }

    private void sendToAll(ProtocolManager pm, PacketContainer packet, Player[] players) {
        for (Player p : players) {
            try {
                pm.sendServerPacket(p, packet);
            }
            catch (Exception e) {
                Bukkit.getLogger().warning("Failed to send packet to " + p.getName() + ": " + e.getMessage());
            }
        }
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "packet based " + (this.isYaw ? "yaw" : "pitch");
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.isYaw = parseResult.mark == 0;
        return super.init(expressions, matchedPattern, kleenean, parseResult);
    }

    static {
        Object FIELD_X_ROT_TEMP;
        Object FIELD_Y_ROT_TEMP;
        Object[] values;
        ExprPacketYawPitch.register(ExprPacketYawPitch.class, Number.class, (String)"packet [based] (0\u00a6yaw|1\u00a6pitch)", (String)"players");
        FIELD_ROTATE_DELTA = null;
        POSITION_MOVE_ROTATION = null;
        Vec3_ZERO = null;
        if (MinecraftVersion.getCurrentVersion().isAtLeast(new MinecraftVersion("1.21.3"))) {
            RELATIVE_CLASS = MinecraftReflection.getMinecraftClass((String)"world.entity.Relative");
            Class vec3 = MinecraftReflection.getMinecraftClass((String)"world.phys.Vec3");
            try {
                Vec3_ZERO = vec3.getDeclaredField("ZERO").get(null);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get Vec3.ZERO field", e);
            }
            Class positionMoveRotation = MinecraftReflection.getMinecraftClass((String)"world.entity.PositionMoveRotation");
            try {
                POSITION_MOVE_ROTATION = positionMoveRotation.getDeclaredConstructor(Vec3_ZERO.getClass(), Vec3_ZERO.getClass(), Float.TYPE, Float.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            try {
                FIELD_ROTATE_DELTA = RELATIVE_CLASS.getDeclaredField("ROTATE_DELTA").get(null);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get ROTATE_DELTA field", e);
            }
            version = 2;
        } else if (MinecraftVersion.getCurrentVersion().isAtLeast(new MinecraftVersion("1.19.4"))) {
            RELATIVE_CLASS = MinecraftReflection.getMinecraftClass((String)"world.entity.RelativeMovement");
            System.out.println(RELATIVE_CLASS);
            version = 1;
        } else {
            RELATIVE_CLASS = MinecraftReflection.getMinecraftClass((String)"PacketPlayOutPosition$EnumPlayerTeleportFlags");
            version = 0;
        }
        try {
            values = (Object[])RELATIVE_CLASS.getDeclaredMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to get " + ExprPacketYawPitch.getVersionClassName() + " values", e);
        }
        FIELD_ALL = new HashSet<Object>(Arrays.asList(values));
        try {
            FIELD_Y_ROT_TEMP = RELATIVE_CLASS.getDeclaredField("Y_ROT").get(null);
            FIELD_X_ROT_TEMP = RELATIVE_CLASS.getDeclaredField("X_ROT").get(null);
        }
        catch (Exception e) {
            try {
                FIELD_Y_ROT_TEMP = RELATIVE_CLASS.getDeclaredField("d");
                FIELD_X_ROT_TEMP = RELATIVE_CLASS.getDeclaredField("e");
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException("Failed to cache " + ExprPacketYawPitch.getVersionClassName() + " fields", e);
            }
        }
        FIELD_Y_ROT = FIELD_Y_ROT_TEMP;
        FIELD_X_ROT = FIELD_X_ROT_TEMP;
    }
}

