/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio;

import java.util.Set;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.AirbagEnchant;
import me.youhavetrouble.enchantio.enchants.BeheadingEnchant;
import me.youhavetrouble.enchantio.enchants.CloakingEnchant;
import me.youhavetrouble.enchantio.enchants.ExecutionerEnchant;
import me.youhavetrouble.enchantio.enchants.HomecomingEnchant;
import me.youhavetrouble.enchantio.enchants.InsomniaEnchant;
import me.youhavetrouble.enchantio.enchants.PanicEnchant;
import me.youhavetrouble.enchantio.enchants.ReplantingEnchant;
import me.youhavetrouble.enchantio.enchants.SmeltingEnchant;
import me.youhavetrouble.enchantio.enchants.SoulboundEnchant;
import me.youhavetrouble.enchantio.enchants.TelepathyEnchant;
import me.youhavetrouble.enchantio.enchants.VampirismEnchant;
import me.youhavetrouble.enchantio.enchants.VolleyEnchant;
import me.youhavetrouble.enchantio.enchants.WardEnchant;
import me.youhavetrouble.enchantio.listeners.AirbagListener;
import me.youhavetrouble.enchantio.listeners.BeheadingListener;
import me.youhavetrouble.enchantio.listeners.CloakingListener;
import me.youhavetrouble.enchantio.listeners.ExecutionerListener;
import me.youhavetrouble.enchantio.listeners.HomecomingListener;
import me.youhavetrouble.enchantio.listeners.InsomniaListener;
import me.youhavetrouble.enchantio.listeners.PanicListener;
import me.youhavetrouble.enchantio.listeners.ReplantingListener;
import me.youhavetrouble.enchantio.listeners.SmeltingListener;
import me.youhavetrouble.enchantio.listeners.SoulboundListener;
import me.youhavetrouble.enchantio.listeners.TelepathyListener;
import me.youhavetrouble.enchantio.listeners.VampirismListener;
import me.youhavetrouble.enchantio.listeners.VolleyListener;
import me.youhavetrouble.enchantio.listeners.WardListener;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class Enchantio
extends JavaPlugin {
    public void onEnable() {
        if (EnchantioConfig.ENCHANTS.containsKey(SoulboundEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new SoulboundListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(TelepathyEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new TelepathyListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(ReplantingEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new ReplantingListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(ExecutionerEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new ExecutionerListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(BeheadingEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new BeheadingListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(SmeltingEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new SmeltingListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(AirbagEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new AirbagListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(HomecomingEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new HomecomingListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(CloakingEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new CloakingListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(VolleyEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new VolleyListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(WardEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new WardListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(PanicEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new PanicListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(VampirismEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new VampirismListener(), (Plugin)this);
        }
        if (EnchantioConfig.ENCHANTS.containsKey(InsomniaEnchant.KEY)) {
            this.getServer().getPluginManager().registerEvents((Listener)new InsomniaListener(), (Plugin)this);
        }
    }

    public void onDisable() {
        if (this.getServer().isStopping()) {
            return;
        }
        this.getLogger().severe("Enchantio is being disabled without a server shutdown. Server will be shut down to prevent issues.");
        this.getServer().shutdown();
    }

    public static int getHighestEnchantLevel(@NotNull EntityEquipment equipment, @NotNull Enchantment enchantment) {
        ItemStack helmet;
        ItemStack chestplate;
        ItemStack leggings;
        ItemStack boots;
        int highestLevel = 0;
        Set equipmentSlotGroups = enchantment.getActiveSlotGroups();
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.FEET)) && (boots = equipment.getBoots()) != null) {
            highestLevel = Math.max(highestLevel, boots.getEnchantmentLevel(enchantment));
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.LEGS)) && (leggings = equipment.getLeggings()) != null) {
            highestLevel = Math.max(highestLevel, leggings.getEnchantmentLevel(enchantment));
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.CHEST)) && (chestplate = equipment.getChestplate()) != null) {
            highestLevel = Math.max(highestLevel, chestplate.getEnchantmentLevel(enchantment));
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.HEAD)) && (helmet = equipment.getHelmet()) != null) {
            highestLevel = Math.max(highestLevel, helmet.getEnchantmentLevel(enchantment));
        }
        if (equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.HAND) || equipmentSlotGroups.contains(EquipmentSlotGroup.MAINHAND)) {
            highestLevel = Math.max(highestLevel, equipment.getItemInMainHand().getEnchantmentLevel(enchantment));
        }
        if (equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.HAND) || equipmentSlotGroups.contains(EquipmentSlotGroup.OFFHAND)) {
            highestLevel = Math.max(highestLevel, equipment.getItemInOffHand().getEnchantmentLevel(enchantment));
        }
        return highestLevel;
    }

    public static int getSumOfEnchantLevels(@NotNull EntityEquipment equipment, @NotNull Enchantment enchantment) {
        ItemStack helmet;
        ItemStack chestplate;
        ItemStack leggings;
        ItemStack boots;
        int level = 0;
        Set equipmentSlotGroups = enchantment.getActiveSlotGroups();
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.FEET)) && (boots = equipment.getBoots()) != null) {
            level += boots.getEnchantmentLevel(enchantment);
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.LEGS)) && (leggings = equipment.getLeggings()) != null) {
            level += leggings.getEnchantmentLevel(enchantment);
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.CHEST)) && (chestplate = equipment.getChestplate()) != null) {
            level += chestplate.getEnchantmentLevel(enchantment);
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.HEAD)) && (helmet = equipment.getHelmet()) != null) {
            level += helmet.getEnchantmentLevel(enchantment);
        }
        if (equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.HAND) || equipmentSlotGroups.contains(EquipmentSlotGroup.MAINHAND)) {
            ItemStack mainHand = equipment.getItemInMainHand();
            level += mainHand.getEnchantmentLevel(enchantment);
        }
        if (equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.HAND) || equipmentSlotGroups.contains(EquipmentSlotGroup.OFFHAND)) {
            ItemStack offHand = equipment.getItemInOffHand();
            level += offHand.getEnchantmentLevel(enchantment);
        }
        return level;
    }
}

