/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.tag.PreFlattenTagRegistrar;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.EnchantioEnchant;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnchantioBootstrap
implements PluginBootstrap {
    private final Logger logger = LoggerFactory.getLogger((String)"Enchantio");

    public void bootstrap(@NotNull BootstrapContext context) {
        try {
            EnchantioConfig.init(context.getDataDirectory());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collection<EnchantioEnchant> enchantioEnchants = EnchantioConfig.ENCHANTS.values();
        this.logger.info("Registering supported item tags");
        context.getLifecycleManager().registerEventHandler(LifecycleEvents.TAGS.preFlatten(RegistryKey.ITEM).newHandler(event -> {
            for (EnchantioEnchant enchant : enchantioEnchants) {
                this.logger.info("Registering item tag {}", (Object)enchant.getTagForSupportedItems().key());
                ((PreFlattenTagRegistrar)event.registrar()).addToTag(ItemTypeTagKeys.create((Key)enchant.getTagForSupportedItems().key()), enchant.getSupportedItems());
            }
        }));
        context.getLifecycleManager().registerEventHandler(RegistryEvents.ENCHANTMENT.compose().newHandler(event -> {
            for (EnchantioEnchant enchant : enchantioEnchants) {
                this.logger.info("Registering enchantment {}", (Object)enchant.getKey());
                event.registry().register(TypedKey.create((RegistryKey)RegistryKey.ENCHANTMENT, (Key)enchant.getKey()), enchantment -> {
                    enchantment.description(enchant.getDescription());
                    enchantment.anvilCost(enchant.getAnvilCost());
                    enchantment.maxLevel(enchant.getMaxLevel());
                    enchantment.weight(enchant.getWeight());
                    enchantment.minimumCost(enchant.getMinimumCost());
                    enchantment.maximumCost(enchant.getMaximumCost());
                    enchantment.activeSlots(enchant.getActiveSlots());
                    enchantment.supportedItems((RegistryKeySet)event.getOrCreateTag(enchant.getTagForSupportedItems()));
                });
            }
        }));
        context.getLifecycleManager().registerEventHandler(LifecycleEvents.TAGS.preFlatten(RegistryKey.ENCHANTMENT).newHandler(event -> {
            for (EnchantioEnchant enchant : enchantioEnchants) {
                enchant.getEnchantTagKeys().forEach(enchantmentTagKey -> ((PreFlattenTagRegistrar)event.registrar()).addToTag(enchantmentTagKey, Set.of(enchant.getTagEntry())));
            }
        }));
    }
}

