/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio;

import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.keys.tags.EnchantmentTagKeys;
import io.papermc.paper.registry.keys.tags.ItemTypeTagKeys;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.TagEntry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.youhavetrouble.enchantio.enchants.AirbagEnchant;
import me.youhavetrouble.enchantio.enchants.BeheadingEnchant;
import me.youhavetrouble.enchantio.enchants.CloakingEnchant;
import me.youhavetrouble.enchantio.enchants.EnchantioEnchant;
import me.youhavetrouble.enchantio.enchants.ExecutionerEnchant;
import me.youhavetrouble.enchantio.enchants.HomecomingEnchant;
import me.youhavetrouble.enchantio.enchants.InsomniaEnchant;
import me.youhavetrouble.enchantio.enchants.PanicEnchant;
import me.youhavetrouble.enchantio.enchants.ReplantingEnchant;
import me.youhavetrouble.enchantio.enchants.SmeltingEnchant;
import me.youhavetrouble.enchantio.enchants.SoulboundEnchant;
import me.youhavetrouble.enchantio.enchants.TelepathyEnchant;
import me.youhavetrouble.enchantio.enchants.VampirismEnchant;
import me.youhavetrouble.enchantio.enchants.VolleyEnchant;
import me.youhavetrouble.enchantio.enchants.WardEnchant;
import net.kyori.adventure.key.Key;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class EnchantioConfig {
    public static final Map<Key, EnchantioEnchant> ENCHANTS = new HashMap<Key, EnchantioEnchant>();
    private static boolean initialized = false;

    protected static void init(Path filePath) throws IOException {
        if (initialized) {
            return;
        }
        initialized = true;
        File file = filePath.toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        File configFile = new File(filePath.toFile(), "config.yml");
        configFile.createNewFile();
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
        ConfigurationSection enchantsSection = EnchantioConfig.getConfigSection((ConfigurationSection)configuration, "enchants");
        EnchantioConfig.migrateEnchantTags(enchantsSection);
        ConfigurationSection soulboundSection = EnchantioConfig.getConfigSection(enchantsSection, "soulbound");
        SoulboundEnchant.create(soulboundSection);
        ConfigurationSection telepathySection = EnchantioConfig.getConfigSection(enchantsSection, "telepathy");
        TelepathyEnchant.create(telepathySection);
        ConfigurationSection replantingSection = EnchantioConfig.getConfigSection(enchantsSection, "replanting");
        ReplantingEnchant.create(replantingSection);
        ConfigurationSection executionerSection = EnchantioConfig.getConfigSection(enchantsSection, "executioner");
        ExecutionerEnchant.create(executionerSection);
        ConfigurationSection beheadingSection = EnchantioConfig.getConfigSection(enchantsSection, "beheading");
        BeheadingEnchant.create(beheadingSection);
        ConfigurationSection smeltingSection = EnchantioConfig.getConfigSection(enchantsSection, "smelting");
        SmeltingEnchant.create(smeltingSection);
        ConfigurationSection airbagSection = EnchantioConfig.getConfigSection(enchantsSection, "airbag");
        AirbagEnchant.create(airbagSection);
        ConfigurationSection homecomingSection = EnchantioConfig.getConfigSection(enchantsSection, "homecoming");
        HomecomingEnchant.create(homecomingSection);
        ConfigurationSection cloakingSection = EnchantioConfig.getConfigSection(enchantsSection, "cloaking");
        CloakingEnchant.create(cloakingSection);
        ConfigurationSection volleySection = EnchantioConfig.getConfigSection(enchantsSection, "volley");
        VolleyEnchant.create(volleySection);
        ConfigurationSection wardSection = EnchantioConfig.getConfigSection(enchantsSection, "ward");
        WardEnchant.create(wardSection);
        ConfigurationSection cursesSection = EnchantioConfig.getConfigSection((ConfigurationSection)configuration, "curses");
        EnchantioConfig.migrateEnchantTags(cursesSection);
        ConfigurationSection panicSection = EnchantioConfig.getConfigSection(cursesSection, "panic");
        PanicEnchant.create(panicSection);
        ConfigurationSection vampirismSection = EnchantioConfig.getConfigSection(cursesSection, "vampirism");
        VampirismEnchant.create(vampirismSection);
        ConfigurationSection insomniaSection = EnchantioConfig.getConfigSection(cursesSection, "insomnia");
        InsomniaEnchant.create(insomniaSection);
        configuration.save(configFile);
    }

    public static List<String> getStringList(ConfigurationSection section, String key, List<String> defaultValue) {
        List list;
        List list2 = list = section.contains(key) ? section.getStringList(key) : null;
        if (list == null) {
            section.set(key, defaultValue);
            return defaultValue;
        }
        return list;
    }

    public static String getString(ConfigurationSection section, String key, String defaultValue) {
        String value;
        String string = value = section.contains(key) ? section.getString(key) : null;
        if (value == null) {
            section.set(key, (Object)defaultValue);
            return defaultValue;
        }
        return value;
    }

    public static int getInt(ConfigurationSection section, String key, int defaultValue) {
        int value;
        int n = value = section.contains(key) ? section.getInt(key) : -1;
        if (value == -1) {
            section.set(key, (Object)defaultValue);
            return defaultValue;
        }
        return value;
    }

    public static double getDouble(ConfigurationSection section, String key, double defaultValue) {
        double value;
        double d = value = section.contains(key) ? section.getDouble(key) : -1.0;
        if (value == -1.0) {
            section.set(key, (Object)defaultValue);
            return defaultValue;
        }
        return value;
    }

    public static boolean getBoolean(ConfigurationSection section, String key, boolean defaultValue) {
        if (!section.contains(key)) {
            section.set(key, (Object)defaultValue);
            return defaultValue;
        }
        return section.getBoolean(key);
    }

    public static void migrateEnchantTags(@NotNull ConfigurationSection section) {
        for (String sectionKey : section.getKeys(false)) {
            ConfigurationSection enchantSection = section.getConfigurationSection(sectionKey);
            if (enchantSection == null) continue;
            if (!enchantSection.isSet("canGetFromEnchantingTable") || enchantSection.isSet("enchantmentTags")) {
                return;
            }
            boolean canGetFromEnchantingTable = section.getBoolean("canGetFromEnchantingTable", true);
            section.set("enchantmentTags", canGetFromEnchantingTable ? List.of("#in_enchanting_table") : List.of());
        }
    }

    public static Set<EquipmentSlotGroup> getEquipmentSlotGroups(@NotNull List<String> slots) {
        HashSet<EquipmentSlotGroup> equipmentSlotGroups = new HashSet<EquipmentSlotGroup>();
        for (String slot : slots) {
            EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.getByName((String)slot);
            if (equipmentSlotGroup == null) continue;
            equipmentSlotGroups.add(equipmentSlotGroup);
        }
        return equipmentSlotGroups;
    }

    public static Set<TagEntry<ItemType>> getItemTagEntriesFromList(@NotNull List<String> tags) {
        HashSet<TagEntry<ItemType>> supportedItemTags = new HashSet<TagEntry<ItemType>>();
        for (String itemTag : tags) {
            TagEntry tagEntry;
            Key key;
            if (itemTag == null) continue;
            if (itemTag.startsWith("#")) {
                itemTag = itemTag.substring(1);
                try {
                    key = Key.key((String)itemTag);
                    TagKey tagKey = ItemTypeTagKeys.create((Key)key);
                    tagEntry = TagEntry.tagEntry((TagKey)tagKey);
                    supportedItemTags.add((TagEntry<ItemType>)tagEntry);
                }
                catch (IllegalArgumentException key2) {}
                continue;
            }
            try {
                key = Key.key((String)itemTag);
                TypedKey typedKey = TypedKey.create((RegistryKey)RegistryKey.ITEM, (Key)key);
                tagEntry = TagEntry.valueEntry((TypedKey)typedKey);
                supportedItemTags.add((TagEntry<ItemType>)tagEntry);
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {}
        }
        return supportedItemTags;
    }

    public static Set<TagKey<Enchantment>> getEnchantmentTagKeysFromList(@NotNull List<String> tags) {
        HashSet<TagKey<Enchantment>> enchantTagKeys = new HashSet<TagKey<Enchantment>>();
        for (String enchantmentTag : tags) {
            Key key;
            if (enchantmentTag == null) continue;
            if (enchantmentTag.startsWith("#")) {
                enchantmentTag = enchantmentTag.substring(1);
                try {
                    key = Key.key((String)enchantmentTag);
                    TagKey tagKey = EnchantmentTagKeys.create((Key)key);
                    enchantTagKeys.add((TagKey<Enchantment>)tagKey);
                }
                catch (IllegalArgumentException key2) {}
                continue;
            }
            try {
                key = Key.key((String)enchantmentTag);
                TypedKey typedKey = TypedKey.create((RegistryKey)RegistryKey.ENCHANTMENT, (Key)key);
                TagKey tagKey = EnchantmentTagKeys.create((Key)key);
                enchantTagKeys.add((TagKey<Enchantment>)tagKey);
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {}
        }
        return enchantTagKeys;
    }

    public static ConfigurationSection getConfigSection(ConfigurationSection section, String key) {
        ConfigurationSection value = section.getConfigurationSection(key);
        if (value == null) {
            value = section.createSection(key);
        }
        return value;
    }
}

