/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.enchants;

import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.TagEntry;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EnchantioEnchant {
    @NotNull
    public Key getKey();

    @NotNull
    public Component getDescription();

    public int getAnvilCost();

    public int getMaxLevel();

    public int getWeight();

    @NotNull
    public EnchantmentRegistryEntry.EnchantmentCost getMinimumCost();

    @NotNull
    public EnchantmentRegistryEntry.EnchantmentCost getMaximumCost();

    @NotNull
    public Iterable<EquipmentSlotGroup> getActiveSlots();

    @NotNull
    public Set<TagEntry<ItemType>> getSupportedItems();

    @NotNull
    public Set<TagKey<Enchantment>> getEnchantTagKeys();

    @NotNull
    default public TagKey<ItemType> getTagForSupportedItems() {
        return TagKey.create((RegistryKey)RegistryKey.ITEM, (Key)Key.key((String)(this.getKey().asString() + "_enchantable")));
    }

    @NotNull
    default public TagEntry<Enchantment> getTagEntry() {
        return TagEntry.valueEntry((TypedKey)TypedKey.create((RegistryKey)RegistryKey.ENCHANTMENT, (Key)this.getKey()));
    }

    @Nullable
    public static ItemStack findFirstWithEnchant(@NotNull EntityEquipment equipment, @NotNull Enchantment enchantment) {
        ItemStack boots;
        ItemStack leggings;
        ItemStack chestplate;
        ItemStack helmet;
        Set equipmentSlotGroups = enchantment.getActiveSlotGroups();
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.HAND) || equipmentSlotGroups.contains(EquipmentSlotGroup.MAINHAND)) && equipment.getItemInMainHand().getEnchantmentLevel(enchantment) > 0) {
            return equipment.getItemInMainHand();
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.HAND) || equipmentSlotGroups.contains(EquipmentSlotGroup.OFFHAND)) && equipment.getItemInOffHand().getEnchantmentLevel(enchantment) > 0) {
            return equipment.getItemInOffHand();
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.HEAD)) && (helmet = equipment.getHelmet()) != null && helmet.getEnchantmentLevel(enchantment) > 0) {
            return helmet;
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.CHEST)) && (chestplate = equipment.getChestplate()) != null && chestplate.getEnchantmentLevel(enchantment) > 0) {
            return chestplate;
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.LEGS)) && (leggings = equipment.getLeggings()) != null && leggings.getEnchantmentLevel(enchantment) > 0) {
            return leggings;
        }
        if ((equipmentSlotGroups.contains(EquipmentSlotGroup.ANY) || equipmentSlotGroups.contains(EquipmentSlotGroup.ARMOR) || equipmentSlotGroups.contains(EquipmentSlotGroup.FEET)) && (boots = equipment.getBoots()) != null && boots.getEnchantmentLevel(enchantment) > 0) {
            return boots;
        }
        return null;
    }
}

