/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.enchants;

import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.TagEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.EnchantioEnchant;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class PanicEnchant
implements EnchantioEnchant {
    public static final Key KEY = Key.key((String)"enchantio:panic_curse");
    private final int anvilCost;
    private final int weight;
    private final int maxLevel;
    private final EnchantmentRegistryEntry.EnchantmentCost minimumCost;
    private final EnchantmentRegistryEntry.EnchantmentCost maximumCost;
    private final double panicChancePerLevel;
    private final Set<TagEntry<ItemType>> supportedItemTags = new HashSet<TagEntry<ItemType>>();
    private final Set<TagKey<Enchantment>> enchantTagKeys = new HashSet<TagKey<Enchantment>>();
    private final Set<EquipmentSlotGroup> activeSlots = new HashSet<EquipmentSlotGroup>();

    public PanicEnchant(int anvilCost, int weight, EnchantmentRegistryEntry.EnchantmentCost minimumCost, EnchantmentRegistryEntry.EnchantmentCost maximumCost, Collection<TagKey<Enchantment>> enchantTagKeys, Collection<TagEntry<ItemType>> supportedItemTags, Collection<EquipmentSlotGroup> activeSlots, int maxLevel, double panicChancePerLevel) {
        this.anvilCost = anvilCost;
        this.weight = weight;
        this.maxLevel = maxLevel;
        this.minimumCost = minimumCost;
        this.maximumCost = maximumCost;
        this.supportedItemTags.addAll(supportedItemTags);
        this.panicChancePerLevel = panicChancePerLevel;
        this.activeSlots.addAll(activeSlots);
        this.enchantTagKeys.addAll(enchantTagKeys);
    }

    @Override
    @NotNull
    public Key getKey() {
        return KEY;
    }

    @Override
    @NotNull
    public Component getDescription() {
        return Component.translatable((String)"enchantio.enchant.panic_curse", (String)"Curse of Panic");
    }

    @Override
    public int getAnvilCost() {
        return this.anvilCost;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EnchantmentRegistryEntry.EnchantmentCost getMinimumCost() {
        return this.minimumCost;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EnchantmentRegistryEntry.EnchantmentCost getMaximumCost() {
        return this.maximumCost;
    }

    @Override
    @NotNull
    public Iterable<EquipmentSlotGroup> getActiveSlots() {
        return this.activeSlots;
    }

    @Override
    @NotNull
    public Set<TagEntry<ItemType>> getSupportedItems() {
        return this.supportedItemTags;
    }

    @Override
    @NotNull
    public Set<TagKey<Enchantment>> getEnchantTagKeys() {
        return Collections.unmodifiableSet(this.enchantTagKeys);
    }

    public double getPanicChancePerLevel() {
        return this.panicChancePerLevel;
    }

    public static PanicEnchant create(ConfigurationSection configurationSection) {
        PanicEnchant panicEnchant = new PanicEnchant(EnchantioConfig.getInt(configurationSection, "anvilCost", 1), EnchantioConfig.getInt(configurationSection, "weight", 2), EnchantmentRegistryEntry.EnchantmentCost.of((int)EnchantioConfig.getInt(configurationSection, "minimumCost.base", 0), (int)EnchantioConfig.getInt(configurationSection, "minimumCost.additionalPerLevel", 3)), EnchantmentRegistryEntry.EnchantmentCost.of((int)EnchantioConfig.getInt(configurationSection, "maximumCost.base", 20), (int)EnchantioConfig.getInt(configurationSection, "maximumCost.additionalPerLevel", 1)), EnchantioConfig.getEnchantmentTagKeysFromList(EnchantioConfig.getStringList(configurationSection, "enchantmentTags", List.of("#in_enchanting_table", "#curse"))), EnchantioConfig.getItemTagEntriesFromList(EnchantioConfig.getStringList(configurationSection, "supportedItemTags", List.of("#minecraft:enchantable/armor"))), EnchantioConfig.getEquipmentSlotGroups(EnchantioConfig.getStringList(configurationSection, "activeSlots", List.of("ARMOR"))), EnchantioConfig.getInt(configurationSection, "maxLevel", 1), EnchantioConfig.getDouble(configurationSection, "panicChancePerLevel", 0.025));
        if (EnchantioConfig.getBoolean(configurationSection, "enabled", true)) {
            EnchantioConfig.ENCHANTS.put(KEY, panicEnchant);
        }
        return panicEnchant;
    }
}

