/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.enchants;

import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.TagEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.EnchantioEnchant;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class TelepathyEnchant
implements EnchantioEnchant {
    public static final Key KEY = Key.key((String)"enchantio:telepathy");
    private final int anvilCost;
    private final int weight;
    private final EnchantmentRegistryEntry.EnchantmentCost minimumCost;
    private final EnchantmentRegistryEntry.EnchantmentCost maximumCost;
    private final Set<TagEntry<ItemType>> supportedItemTags = new HashSet<TagEntry<ItemType>>();
    private final Set<TagKey<Enchantment>> enchantTagKeys = new HashSet<TagKey<Enchantment>>();
    private final Set<EquipmentSlotGroup> activeSlots = new HashSet<EquipmentSlotGroup>();
    private final boolean onlyUserCanPickupItems;

    public TelepathyEnchant(int anvilCost, int weight, EnchantmentRegistryEntry.EnchantmentCost minimumCost, EnchantmentRegistryEntry.EnchantmentCost maximumCost, Collection<TagKey<Enchantment>> enchantTagKeys, Collection<TagEntry<ItemType>> supportedItemTags, Collection<EquipmentSlotGroup> activeSlots, boolean onlyUserCanPickupItems) {
        this.anvilCost = anvilCost;
        this.weight = weight;
        this.minimumCost = minimumCost;
        this.maximumCost = maximumCost;
        this.supportedItemTags.addAll(supportedItemTags);
        this.activeSlots.addAll(activeSlots);
        this.enchantTagKeys.addAll(enchantTagKeys);
        this.onlyUserCanPickupItems = onlyUserCanPickupItems;
    }

    @Override
    @NotNull
    public Key getKey() {
        return KEY;
    }

    @Override
    @NotNull
    public Component getDescription() {
        return Component.translatable((String)"enchantio.enchant.telepathy", (String)"Telepathy");
    }

    @Override
    public int getAnvilCost() {
        return this.anvilCost;
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EnchantmentRegistryEntry.EnchantmentCost getMinimumCost() {
        return this.minimumCost;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EnchantmentRegistryEntry.EnchantmentCost getMaximumCost() {
        return this.maximumCost;
    }

    @Override
    @NotNull
    public Iterable<EquipmentSlotGroup> getActiveSlots() {
        return this.activeSlots;
    }

    @Override
    @NotNull
    public Set<TagEntry<ItemType>> getSupportedItems() {
        return this.supportedItemTags;
    }

    @Override
    @NotNull
    public Set<TagKey<Enchantment>> getEnchantTagKeys() {
        return Collections.unmodifiableSet(this.enchantTagKeys);
    }

    public boolean isOnlyUserCanPickupItems() {
        return this.onlyUserCanPickupItems;
    }

    public static TelepathyEnchant create(ConfigurationSection configurationSection) {
        TelepathyEnchant telepathyEnchant = new TelepathyEnchant(EnchantioConfig.getInt(configurationSection, "anvilCost", 1), EnchantioConfig.getInt(configurationSection, "weight", 5), EnchantmentRegistryEntry.EnchantmentCost.of((int)EnchantioConfig.getInt(configurationSection, "minimumCost.base", 15), (int)EnchantioConfig.getInt(configurationSection, "minimumCost.additionalPerLevel", 1)), EnchantmentRegistryEntry.EnchantmentCost.of((int)EnchantioConfig.getInt(configurationSection, "maximumCost.base", 65), (int)EnchantioConfig.getInt(configurationSection, "maximumCost.additionalPerLevel", 1)), EnchantioConfig.getEnchantmentTagKeysFromList(EnchantioConfig.getStringList(configurationSection, "enchantmentTags", List.of("#in_enchanting_table"))), EnchantioConfig.getItemTagEntriesFromList(EnchantioConfig.getStringList(configurationSection, "supportedItemTags", List.of("#minecraft:enchantable/mining"))), EnchantioConfig.getEquipmentSlotGroups(EnchantioConfig.getStringList(configurationSection, "activeSlots", List.of("MAINHAND"))), EnchantioConfig.getBoolean(configurationSection, "onlyUserCanPickupItems", false));
        if (EnchantioConfig.getBoolean(configurationSection, "enabled", true)) {
            EnchantioConfig.ENCHANTS.put(KEY, telepathyEnchant);
        }
        return telepathyEnchant;
    }
}

