/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.enchants;

import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.TagEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.EnchantioEnchant;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class WardEnchant
implements EnchantioEnchant {
    public static final Key KEY = Key.key((String)"enchantio:ward");
    private final int anvilCost;
    private final int weight;
    private final int cooldownTicks;
    private final EnchantmentRegistryEntry.EnchantmentCost minimumCost;
    private final EnchantmentRegistryEntry.EnchantmentCost maximumCost;
    private final Set<TagEntry<ItemType>> supportedItemTags = new HashSet<TagEntry<ItemType>>();
    private final Set<TagKey<Enchantment>> enchantTagKeys = new HashSet<TagKey<Enchantment>>();
    private final Set<EquipmentSlotGroup> activeSlots = new HashSet<EquipmentSlotGroup>();
    private final String blockSound;

    public WardEnchant(int anvilCost, int weight, EnchantmentRegistryEntry.EnchantmentCost minimumCost, EnchantmentRegistryEntry.EnchantmentCost maximumCost, Collection<TagKey<Enchantment>> enchantTagKeys, Collection<TagEntry<ItemType>> supportedItemTags, Collection<EquipmentSlotGroup> activeSlots, int cooldownTicks, String blockSound) {
        this.anvilCost = anvilCost;
        this.weight = weight;
        this.minimumCost = minimumCost;
        this.maximumCost = maximumCost;
        this.supportedItemTags.addAll(supportedItemTags);
        this.activeSlots.addAll(activeSlots);
        this.cooldownTicks = cooldownTicks;
        this.blockSound = blockSound;
        this.enchantTagKeys.addAll(enchantTagKeys);
    }

    @Override
    @NotNull
    public Key getKey() {
        return KEY;
    }

    @Override
    @NotNull
    public Component getDescription() {
        return Component.translatable((String)"enchantio.enchant.ward", (String)"Ward");
    }

    @Override
    public int getAnvilCost() {
        return this.anvilCost;
    }

    @Override
    public int getMaxLevel() {
        return 1;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EnchantmentRegistryEntry.EnchantmentCost getMinimumCost() {
        return this.minimumCost;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EnchantmentRegistryEntry.EnchantmentCost getMaximumCost() {
        return this.maximumCost;
    }

    @Override
    @NotNull
    public Iterable<EquipmentSlotGroup> getActiveSlots() {
        return this.activeSlots;
    }

    @Override
    @NotNull
    public Set<TagEntry<ItemType>> getSupportedItems() {
        return this.supportedItemTags;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    @NotNull
    public String getBlockSound() {
        return this.blockSound;
    }

    @Override
    @NotNull
    public Set<TagKey<Enchantment>> getEnchantTagKeys() {
        return Collections.unmodifiableSet(this.enchantTagKeys);
    }

    public static WardEnchant create(ConfigurationSection configurationSection) {
        WardEnchant wardEnchant = new WardEnchant(EnchantioConfig.getInt(configurationSection, "anvilCost", 12), EnchantioConfig.getInt(configurationSection, "weight", 2), EnchantmentRegistryEntry.EnchantmentCost.of((int)EnchantioConfig.getInt(configurationSection, "minimumCost.base", 35), (int)EnchantioConfig.getInt(configurationSection, "minimumCost.additionalPerLevel", 1)), EnchantmentRegistryEntry.EnchantmentCost.of((int)EnchantioConfig.getInt(configurationSection, "maximumCost.base", 65), (int)EnchantioConfig.getInt(configurationSection, "maximumCost.additionalPerLevel", 1)), EnchantioConfig.getEnchantmentTagKeysFromList(EnchantioConfig.getStringList(configurationSection, "enchantmentTags", List.of("#in_enchanting_table"))), EnchantioConfig.getItemTagEntriesFromList(EnchantioConfig.getStringList(configurationSection, "supportedItemTags", List.of("minecraft:shield"))), EnchantioConfig.getEquipmentSlotGroups(EnchantioConfig.getStringList(configurationSection, "activeSlots", List.of("OFFHAND"))), EnchantioConfig.getInt(configurationSection, "cooldownTicks", 40), EnchantioConfig.getString(configurationSection, "blockSound", "minecraft:item.shield.block"));
        if (EnchantioConfig.getBoolean(configurationSection, "enabled", true)) {
            EnchantioConfig.ENCHANTS.put(KEY, wardEnchant);
        }
        return wardEnchant;
    }
}

