/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.events;

import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerPanicEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    private boolean cancelled = false;
    private final List<ItemStack> scrambledItems;

    public PlayerPanicEvent(@NotNull Player player, @NotNull List<ItemStack> scrambledItems) {
        super(player);
        this.scrambledItems = scrambledItems;
    }

    public List<ItemStack> getScrambledItems() {
        return Collections.unmodifiableList(this.scrambledItems);
    }

    public void setScrambledItems(@NotNull List<ItemStack> scrambledItems) {
        if (scrambledItems.size() != 9) {
            throw new IllegalArgumentException("Scrambled items must have a size of 9");
        }
        this.scrambledItems.clear();
        this.scrambledItems.addAll(scrambledItems);
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

