/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.listeners;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import me.youhavetrouble.enchantio.Enchantio;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.AirbagEnchant;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EntityEquipment;

public class AirbagListener
implements Listener {
    private final Registry<Enchantment> registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
    private final Enchantment airbag = (Enchantment)this.registry.get(AirbagEnchant.KEY);

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onCushionedFall(EntityDamageEvent event) {
        if (this.airbag == null) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!event.getCause().equals((Object)EntityDamageEvent.DamageCause.FLY_INTO_WALL)) {
            return;
        }
        double damage = event.getDamage();
        EntityEquipment entityEquipment = livingEntity.getEquipment();
        if (entityEquipment == null) {
            return;
        }
        int levels = Enchantio.getSumOfEnchantLevels(entityEquipment, this.airbag);
        if (levels == 0) {
            return;
        }
        AirbagEnchant airbagEnchant = (AirbagEnchant)EnchantioConfig.ENCHANTS.get(AirbagEnchant.KEY);
        double percentageDamageReduction = Math.min(1.0, (double)levels * airbagEnchant.getDamageReductionPerLevel());
        event.setDamage(damage * (1.0 - percentageDamageReduction));
    }
}

