/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.listeners;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import me.youhavetrouble.enchantio.Enchantio;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.BeheadingEnchant;
import me.youhavetrouble.enchantio.enchants.EnchantioEnchant;
import me.youhavetrouble.enchantio.events.EntityBeheadEvent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class BeheadingListener
implements Listener {
    private final Registry<Enchantment> registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
    private final Enchantment beheading = (Enchantment)this.registry.get(BeheadingEnchant.KEY);

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onBeheading(EntityDeathEvent event) {
        if (this.beheading == null) {
            return;
        }
        EnchantioEnchant enchant = EnchantioConfig.ENCHANTS.get(BeheadingEnchant.KEY);
        if (!(enchant instanceof BeheadingEnchant)) {
            return;
        }
        BeheadingEnchant beheadingEnchant = (BeheadingEnchant)enchant;
        if (event.getDamageSource().isIndirect()) {
            return;
        }
        Entity killer = event.getDamageSource().getCausingEntity();
        if (killer == null) {
            return;
        }
        if (!(killer instanceof LivingEntity)) {
            return;
        }
        LivingEntity killerEntity = (LivingEntity)killer;
        EntityEquipment killerEquipment = killerEntity.getEquipment();
        if (killerEquipment == null) {
            return;
        }
        int level = Enchantio.getHighestEnchantLevel(killerEquipment, this.beheading);
        if (level == 0) {
            return;
        }
        double chance = (double)level * beheadingEnchant.getChanceToDropHeadPerLevel();
        if (ThreadLocalRandom.current().nextDouble() > chance) {
            return;
        }
        ItemStack head = this.getHeadForEntity((Entity)event.getEntity(), event.getDrops());
        if (head == null) {
            return;
        }
        EntityBeheadEvent beheadEvent = new EntityBeheadEvent((Entity)event.getEntity(), head);
        Bukkit.getPluginManager().callEvent((Event)beheadEvent);
        if (beheadEvent.isCancelled()) {
            return;
        }
        event.getDrops().add(beheadEvent.getHeadToDrop());
    }

    private ItemStack getHeadForEntity(Entity entity, Collection<ItemStack> drops) {
        ItemStack head = null;
        switch (entity.getType()) {
            case ZOMBIE: {
                if (this.listContainsItemType(drops, Material.ZOMBIE_HEAD)) {
                    return null;
                }
                head = new ItemStack(Material.ZOMBIE_HEAD);
                break;
            }
            case PIGLIN: {
                if (this.listContainsItemType(drops, Material.PIGLIN_HEAD)) {
                    return null;
                }
                head = new ItemStack(Material.PIGLIN_HEAD);
                break;
            }
            case WITHER_SKELETON: {
                if (this.listContainsItemType(drops, Material.WITHER_SKELETON_SKULL)) {
                    return null;
                }
                head = new ItemStack(Material.WITHER_SKELETON_SKULL);
                break;
            }
            case SKELETON: {
                if (this.listContainsItemType(drops, Material.SKELETON_SKULL)) {
                    return null;
                }
                head = new ItemStack(Material.SKELETON_SKULL);
                break;
            }
            case CREEPER: {
                if (this.listContainsItemType(drops, Material.CREEPER_HEAD)) {
                    return null;
                }
                head = new ItemStack(Material.CREEPER_HEAD);
                break;
            }
            case ENDER_DRAGON: {
                if (this.listContainsItemType(drops, Material.DRAGON_HEAD)) {
                    return null;
                }
                head = new ItemStack(Material.DRAGON_HEAD);
                break;
            }
            case PLAYER: {
                if (this.listContainsItemType(drops, Material.PLAYER_HEAD)) {
                    return null;
                }
                Player player = (Player)entity;
                head = this.getPlayerHead(player);
            }
        }
        return head;
    }

    private boolean listContainsItemType(@NotNull Iterable<ItemStack> list, @NotNull Material type) {
        for (ItemStack item : list) {
            if (!type.equals((Object)item.getType())) continue;
            return true;
        }
        return false;
    }

    private ItemStack getPlayerHead(@NotNull Player player) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer((OfflinePlayer)player);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }
}

