/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.listeners;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.UUID;
import me.youhavetrouble.enchantio.Enchantio;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.CloakingEnchant;
import org.bukkit.Bukkit;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CloakingListener
implements Listener {
    private final HashMap<UUID, Long> ticksSinceLastMovement = new HashMap();
    private final CloakingEnchant cloakingEnchant = (CloakingEnchant)EnchantioConfig.ENCHANTS.get(CloakingEnchant.KEY);
    private final PotionEffect cloakingEffect = new PotionEffect(PotionEffectType.INVISIBILITY, 3, 0, false, false, false);
    private final Registry<Enchantment> registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
    private final Enchantment cloaking = (Enchantment)this.registry.get(CloakingEnchant.KEY);

    public CloakingListener() {
        if (this.cloaking == null) {
            return;
        }
        Enchantio enchantio = (Enchantio)Enchantio.getPlugin(Enchantio.class);
        Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)enchantio, task -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isSneaking()) {
                    this.ticksSinceLastMovement.put(player.getUniqueId(), 0L);
                    continue;
                }
                int cloakingLevel = Enchantio.getSumOfEnchantLevels(player.getEquipment(), this.cloaking);
                if (cloakingLevel == 0) continue;
                this.ticksSinceLastMovement.computeIfPresent(player.getUniqueId(), (uuid, ticks) -> ticks + 1L);
                if (this.ticksSinceLastMovement.getOrDefault(player.getUniqueId(), 0L) < (long)this.cloakingEnchant.getTicksToActivate()) continue;
                player.getScheduler().execute((Plugin)enchantio, () -> player.addPotionEffect(this.cloakingEffect), () -> {}, 1L);
            }
        }, 1L, 1L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.ticksSinceLastMovement.put(event.getPlayer().getUniqueId(), 0L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.ticksSinceLastMovement.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!event.hasChangedPosition()) {
            return;
        }
        this.ticksSinceLastMovement.put(event.getPlayer().getUniqueId(), 0L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerJump(PlayerJumpEvent event) {
        this.ticksSinceLastMovement.put(event.getPlayer().getUniqueId(), 0L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.ticksSinceLastMovement.put(event.getPlayer().getUniqueId(), 0L);
    }
}

