/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.listeners;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import me.youhavetrouble.enchantio.Enchantio;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.EnchantioEnchant;
import me.youhavetrouble.enchantio.enchants.ExecutionerEnchant;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.jetbrains.annotations.NotNull;

public class ExecutionerListener
implements Listener {
    private final Registry<@NotNull Enchantment> registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
    private final Enchantment executioner = (Enchantment)this.registry.get(ExecutionerEnchant.KEY);

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onExecutionerDamage(EntityDamageByEntityEvent event) {
        if (this.executioner == null) {
            return;
        }
        EnchantioEnchant enchant = EnchantioConfig.ENCHANTS.get(ExecutionerEnchant.KEY);
        if (!(enchant instanceof ExecutionerEnchant)) {
            return;
        }
        ExecutionerEnchant executionerEnchant = (ExecutionerEnchant)enchant;
        Entity damager = event.getDamageSource().getCausingEntity();
        if (damager == null) {
            return;
        }
        if (!damager.equals((Object)event.getDamageSource().getDirectEntity())) {
            return;
        }
        if (!(damager instanceof LivingEntity)) {
            return;
        }
        LivingEntity damagerEntity = (LivingEntity)damager;
        EntityEquipment damagerEquipment = damagerEntity.getEquipment();
        if (damagerEquipment == null) {
            return;
        }
        int level = Enchantio.getSumOfEnchantLevels(damagerEquipment, this.executioner);
        if (level == 0) {
            return;
        }
        Entity target = event.getEntity();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)target;
        AttributeInstance maxHealthAttribute = livingEntity.getAttribute(Attribute.MAX_HEALTH);
        if (maxHealthAttribute == null) {
            return;
        }
        double targetMaxHealth = maxHealthAttribute.getValue();
        double targetHealthPercentage = livingEntity.getHealth() / targetMaxHealth;
        if (targetHealthPercentage < executionerEnchant.getMaxDamageHpThreshold()) {
            double damageMultiplier = 1.0 + executionerEnchant.getDamageMultiplierPerLevel() * (double)level;
            event.setDamage(event.getDamage() * damageMultiplier);
        }
    }
}

