/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.listeners;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import me.youhavetrouble.enchantio.enchants.HomecomingEnchant;
import me.youhavetrouble.enchantio.events.HomecomingEvent;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class HomecomingListener
implements Listener {
    private final Registry<Enchantment> registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
    private final Enchantment homecoming = (Enchantment)this.registry.get(HomecomingEnchant.KEY);

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onHomecoming(EntityResurrectEvent event) {
        if (this.homecoming == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        EquipmentSlot equipmentSlot = event.getHand();
        if (equipmentSlot == null) {
            return;
        }
        EntityEquipment entityEquipment = event.getEntity().getEquipment();
        if (entityEquipment == null) {
            return;
        }
        ItemStack item = entityEquipment.getItem(equipmentSlot);
        if (!item.containsEnchantment(this.homecoming)) {
            return;
        }
        Location location = player.getRespawnLocation();
        if (location == null) {
            location = player.getWorld().getSpawnLocation();
        }
        HomecomingEvent homecomingEvent = new HomecomingEvent(player, location);
        player.getServer().getPluginManager().callEvent((Event)homecomingEvent);
        if (homecomingEvent.isCancelled()) {
            return;
        }
        player.teleportAsync(homecomingEvent.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
    }
}

