/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.listeners;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import me.youhavetrouble.enchantio.Enchantio;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.EnchantioEnchant;
import me.youhavetrouble.enchantio.enchants.PanicEnchant;
import me.youhavetrouble.enchantio.events.PlayerPanicEvent;
import org.bukkit.Bukkit;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PanicListener
implements Listener {
    private final Registry<Enchantment> registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
    private final Enchantment panic = (Enchantment)this.registry.get(PanicEnchant.KEY);

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onPlayerPanic(EntityDamageEvent event) {
        if (this.panic == null) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        EnchantioEnchant enchant = EnchantioConfig.ENCHANTS.get(PanicEnchant.KEY);
        if (!(enchant instanceof PanicEnchant)) {
            return;
        }
        PanicEnchant panicEnchant = (PanicEnchant)enchant;
        EntityEquipment equipment = player.getEquipment();
        int level = Enchantio.getHighestEnchantLevel(equipment, this.panic);
        if (level == 0) {
            return;
        }
        double chance = (double)level * panicEnchant.getPanicChancePerLevel();
        if (ThreadLocalRandom.current().nextDouble() > chance) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ArrayList<ItemStack> hotbarItems = new ArrayList<ItemStack>(Arrays.stream(inventory.getContents()).toList().subList(0, 9));
        Collections.shuffle(hotbarItems, ThreadLocalRandom.current());
        PlayerPanicEvent playerPanicEvent = new PlayerPanicEvent(player, hotbarItems);
        Bukkit.getPluginManager().callEvent((Event)playerPanicEvent);
        if (playerPanicEvent.isCancelled()) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            inventory.setItem(i, playerPanicEvent.getScrambledItems().get(i));
        }
    }
}

