/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.listeners;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import me.youhavetrouble.enchantio.enchants.ReplantingEnchant;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.block.BlockState;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class ReplantingListener
implements Listener {
    private final Registry<Enchantment> enchantmentRegistry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
    private final Tag<Material> cropTag = Tag.CROPS;
    private final Enchantment replanting = (Enchantment)this.enchantmentRegistry.get(ReplantingEnchant.KEY);

    @EventHandler(ignoreCancelled=true, priority=EventPriority.NORMAL)
    public void onReplantingTool(BlockDropItemEvent event) {
        if (this.replanting == null) {
            return;
        }
        ItemStack tool = event.getPlayer().getInventory().getItemInMainHand();
        if (!tool.containsEnchantment(this.replanting)) {
            return;
        }
        BlockState block = event.getBlockState();
        if (this.cropTag == null) {
            return;
        }
        if (!this.cropTag.isTagged((Keyed)block.getType())) {
            return;
        }
        Material placementMaterial = block.getBlockData().getPlacementMaterial();
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        boolean shouldReplant = player.getGameMode().equals((Object)GameMode.CREATIVE);
        if (!shouldReplant) {
            for (ItemStack item : inventory.getContents()) {
                if (item == null || item.getType() != placementMaterial) continue;
                item.setAmount(item.getAmount() - 1);
                shouldReplant = true;
                break;
            }
        }
        if (!shouldReplant) {
            for (Item item : event.getItems()) {
                ItemStack itemStack = item.getItemStack();
                if (!itemStack.getType().equals((Object)placementMaterial)) continue;
                itemStack.setAmount(itemStack.getAmount() - 1);
                shouldReplant = true;
                break;
            }
        }
        if (!shouldReplant) {
            return;
        }
        event.getBlock().setType(block.getType());
    }
}

