/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.listeners;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.youhavetrouble.enchantio.enchants.SmeltingEnchant;
import org.bukkit.Bukkit;
import org.bukkit.Registry;
import org.bukkit.block.BlockState;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;

public class SmeltingListener
implements Listener {
    private final Registry<Enchantment> registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
    private final Enchantment smelting = (Enchantment)this.registry.get(SmeltingEnchant.KEY);
    private final Map<ItemStack, ItemStack> smeltingCache = new HashMap<ItemStack, ItemStack>();

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onSmeltingEnchantSmelt(BlockDropItemEvent event) {
        if (this.smelting == null) {
            return;
        }
        ItemStack tool = event.getPlayer().getInventory().getItemInMainHand();
        if (!tool.containsEnchantment(this.smelting)) {
            return;
        }
        BlockState block = event.getBlockState();
        if (block instanceof BlockInventoryHolder) {
            return;
        }
        for (Item item : event.getItems()) {
            int amount = item.getItemStack().getAmount();
            ItemStack smeltedItem = this.getSmeltedItem(item.getItemStack());
            if (smeltedItem == null) continue;
            item.setItemStack(smeltedItem.asQuantity(amount));
        }
    }

    private ItemStack getSmeltedItem(@NotNull ItemStack itemStack) {
        ItemStack singleItem = itemStack.asOne();
        if (this.smeltingCache.containsKey(singleItem)) {
            return this.smeltingCache.get(singleItem);
        }
        @NotNull Iterator it = Bukkit.recipeIterator();
        while (it.hasNext()) {
            FurnaceRecipe furnaceRecipe;
            Recipe recipe = (Recipe)it.next();
            if (!(recipe instanceof FurnaceRecipe) || !(furnaceRecipe = (FurnaceRecipe)recipe).getInputChoice().test(singleItem)) continue;
            ItemStack result = furnaceRecipe.getResult();
            this.smeltingCache.put(singleItem, result);
            return result;
        }
        return null;
    }
}

