/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.listeners;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.EnchantioEnchant;
import me.youhavetrouble.enchantio.enchants.ExecutionerEnchant;
import me.youhavetrouble.enchantio.enchants.VolleyEnchant;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class VolleyListener
implements Listener {
    private final Registry<@NotNull Enchantment> registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
    private final Enchantment volley = (Enchantment)this.registry.get(VolleyEnchant.KEY);
    private final Random random = ThreadLocalRandom.current();

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onVolley(ProjectileLaunchEvent event) {
        if (this.volley == null) {
            return;
        }
        Projectile projectileEntity = event.getEntity();
        if (CreatureSpawnEvent.SpawnReason.ENCHANTMENT.equals((Object)projectileEntity.getEntitySpawnReason())) {
            return;
        }
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (!(projectileSource instanceof LivingEntity)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)projectileSource;
        EntityEquipment equipment = shooter.getEquipment();
        if (equipment == null) {
            return;
        }
        ItemStack bow = equipment.getItemInMainHand();
        int level = bow.getEnchantmentLevel(this.volley);
        if (level <= 0) {
            return;
        }
        EnchantioEnchant enchantioEnchant = EnchantioConfig.ENCHANTS.get(ExecutionerEnchant.KEY);
        if (!(enchantioEnchant instanceof VolleyEnchant)) {
            return;
        }
        VolleyEnchant volleyEnchant = (VolleyEnchant)enchantioEnchant;
        double spread = volleyEnchant.getSpread();
        if (projectileEntity instanceof Arrow) {
            Arrow arrow = (Arrow)projectileEntity;
            for (int i = 0; i < level * volleyEnchant.getAdditionalArrowsPerLevel(); ++i) {
                Vector velocity = arrow.getVelocity();
                double spreadX = (this.random.nextDouble() - 0.5) * spread;
                double spreadY = (this.random.nextDouble() - 0.5) * spread;
                double spreadZ = (this.random.nextDouble() - 0.5) * spread;
                Vector newVelocity = velocity.clone().add(new Vector(spreadX, spreadY, spreadZ));
                shooter.getWorld().spawn(arrow.getLocation(), Arrow.class, spawnedArrow -> {
                    spawnedArrow.setVelocity(newVelocity);
                    spawnedArrow.getPersistentDataContainer().set(this.volley.getKey(), PersistentDataType.BOOLEAN, (Object)true);
                    spawnedArrow.setCritical(arrow.isCritical());
                    spawnedArrow.setShooter(arrow.getShooter());
                    spawnedArrow.setHasLeftShooter(arrow.hasLeftShooter());
                    spawnedArrow.setBasePotionType(arrow.getBasePotionType());
                    spawnedArrow.setPickupStatus(AbstractArrow.PickupStatus.CREATIVE_ONLY);
                    arrow.getCustomEffects().forEach(effect -> spawnedArrow.addCustomEffect(effect, false));
                }, CreatureSpawnEvent.SpawnReason.ENCHANTMENT);
            }
            return;
        }
        if (projectileEntity instanceof SpectralArrow) {
            SpectralArrow arrow = (SpectralArrow)projectileEntity;
            arrow.setPickupStatus(AbstractArrow.PickupStatus.CREATIVE_ONLY);
            for (int i = 0; i < level; ++i) {
                Vector velocity = arrow.getVelocity();
                double spreadX = (this.random.nextDouble() - 0.5) * spread;
                double spreadY = (this.random.nextDouble() - 0.5) * spread;
                double spreadZ = (this.random.nextDouble() - 0.5) * spread;
                Vector newVelocity = velocity.clone().add(new Vector(spreadX, spreadY, spreadZ));
                shooter.getWorld().spawn(arrow.getLocation(), SpectralArrow.class, spawnedArrow -> {
                    spawnedArrow.setVelocity(newVelocity);
                    spawnedArrow.getPersistentDataContainer().set(this.volley.getKey(), PersistentDataType.BOOLEAN, (Object)true);
                    spawnedArrow.setCritical(arrow.isCritical());
                    spawnedArrow.setShooter(arrow.getShooter());
                    spawnedArrow.setHasLeftShooter(arrow.hasLeftShooter());
                    spawnedArrow.setPickupStatus(AbstractArrow.PickupStatus.CREATIVE_ONLY);
                }, CreatureSpawnEvent.SpawnReason.ENCHANTMENT);
            }
            return;
        }
    }
}

