/*
 * Decompiled with CFR 0.152.
 */
package me.youhavetrouble.enchantio.listeners;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.time.Instant;
import me.youhavetrouble.enchantio.EnchantioConfig;
import me.youhavetrouble.enchantio.enchants.EnchantioEnchant;
import me.youhavetrouble.enchantio.enchants.WardEnchant;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.SoundCategory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class WardListener
implements Listener {
    private final Registry<@NotNull Enchantment> registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
    private final Enchantment ward = (Enchantment)this.registry.get(WardEnchant.KEY);
    private final NamespacedKey wardKey = new NamespacedKey(WardEnchant.KEY.namespace(), WardEnchant.KEY.value());

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageWithWard(EntityDamageByEntityEvent event) {
        if (this.ward == null) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        EntityEquipment equipment = entity2.getEquipment();
        if (equipment == null) {
            return;
        }
        ItemStack item = EnchantioEnchant.findFirstWithEnchant(equipment, this.ward);
        if (item == null) {
            return;
        }
        EnchantioEnchant enchantioEnchant = EnchantioConfig.ENCHANTS.get(WardEnchant.KEY);
        if (!(enchantioEnchant instanceof WardEnchant)) {
            return;
        }
        WardEnchant wardEnchant = (WardEnchant)enchantioEnchant;
        if (entity2 instanceof HumanEntity) {
            HumanEntity humanEntity = (HumanEntity)entity2;
            if (humanEntity.getCooldown(item) > 0) {
                return;
            }
            if (wardEnchant.getCooldownTicks() > 0) {
                humanEntity.setCooldown(item, wardEnchant.getCooldownTicks());
            }
        } else if (wardEnchant.getCooldownTicks() > 0) {
            PersistentDataContainer pdc = entity2.getPersistentDataContainer();
            Long lastWard = (Long)pdc.get(this.wardKey, PersistentDataType.LONG);
            if (lastWard != null && Instant.now().toEpochMilli() - lastWard < 50L * (long)wardEnchant.getCooldownTicks()) {
                return;
            }
            pdc.set(this.wardKey, PersistentDataType.LONG, (Object)Instant.now().toEpochMilli());
        }
        item.damage((int)Math.ceil(event.getFinalDamage()), entity2);
        entity2.getWorld().playSound((Entity)entity2, wardEnchant.getBlockSound(), SoundCategory.MASTER, 1.0f, 1.0f);
        event.setDamage(0.0);
    }
}

