#version 150

// Import Minecraft-specific GLSL libraries
#moj_import <minecraft:light.glsl>
#moj_import <minecraft:fog.glsl>

// Vertex attributes from the game
in vec3 Position;    // Vertex position
in vec4 Color;       // Vertex color
in vec2 UV0;         // Main texture coordinates
in ivec2 UV1;        // Overlay texture coordinates
in ivec2 UV2;        // Lightmap texture coordinates  
in vec3 Normal;      // Vertex normal

// Uniform variables
uniform sampler2D Sampler1; // Overlay texture sampler
uniform sampler2D Sampler2; // Lightmap texture sampler

uniform mat4 ModelViewMat;  // Model-view transformation matrix
uniform mat4 ProjMat;       // Projection matrix
uniform mat4 TextureMat;    // Texture transformation matrix
uniform int FogShape;       // Fog shape (0=cylindrical, 1=spherical)

uniform vec3 Light0_Direction; // Primary light direction
uniform vec3 Light1_Direction; // Secondary light direction

// Output variables to fragment shader
out float vertexDistance; // Distance for fog calculation
out vec4 vertexColor;     // Vertex color
out vec4 lightMapColor;   // Lightmap color
out vec4 lightColor;      // Computed lighting color
out vec4 overlayColor;    // Overlay texture color
out vec2 texCoord0;       // Transformed texture coordinates

void main() {
    // Transform vertex position to clip space
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);

    // Pass texture coordinates through
    texCoord0 = UV0;
    
    // Calculate vertex distance for fog
    vertexDistance = fog_distance(Position, FogShape);
    
    // Sample lightmap texture (divided by 16 for Minecraft's coordinate system)
    lightMapColor = texelFetch(Sampler2, UV2 / 16, 0);
    
    // Initialize light color
    lightColor = vec4(1);
    
    // Sample overlay texture
    overlayColor = texelFetch(Sampler1, UV1, 0);
    
    // Pass vertex color
    vertexColor = Color;

    // Apply cardinal lighting if not disabled
    #ifndef NO_CARDINAL_LIGHTING
    lightColor *= minecraft_mix_light(Light0_Direction, Light1_Direction, Normal, vec4(1));
    #endif

    // Apply texture matrix transformation if enabled
    #ifdef APPLY_TEXTURE_MATRIX
    texCoord0 = (TextureMat * vec4(UV0, 0.0, 1.0)).xy;
    #endif
}